<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerRating StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer Value Scores and Frequent Flyer Tiers for one traveler. It can influence Availability results when provided.
 * @subpackage Structs
 */
class TravelerRating extends AbstractStructBase
{
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Score[]
     */
    public $Score;
    /**
     * Constructor method for TravelerRating
     * @uses TravelerRating::setScore()
     * @param \SabreSoap\StructType\Score[] $score
     */
    public function __construct(array $score = array())
    {
        $this
            ->setScore($score);
    }
    /**
     * Get Score value
     * @return \SabreSoap\StructType\Score[]|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param \SabreSoap\StructType\Score[] $score
     * @return \SabreSoap\StructType\TravelerRating
     */
    public function setScore(array $score = array())
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Add item to Score value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Score $item
     * @return \SabreSoap\StructType\TravelerRating
     */
    public function addToScore(\SabreSoap\StructType\Score $item)
    {
        $this->Score[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\TravelerRating
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
