<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInfoSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies passenger numbers and types.
 * @subpackage Structs
 */
class TravelerInfoSummaryType extends AbstractStructBase
{
    /**
     * The SeatsRequested
     * Meta information extracted from the WSDL
     * - documentation: The sum of all seats required by all passenger groups.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var int[]
     */
    public $SeatsRequested;
    /**
     * The AirTravelerAvail
     * Meta information extracted from the WSDL
     * - documentation: Specifies passenger numbers and types.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TravelerInformationType[]
     */
    public $AirTravelerAvail;
    /**
     * The PriceRequestInformation
     * Meta information extracted from the WSDL
     * - documentation: Identify pricing source, if negotiated fares are requested and if it is a reprice request.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PriceRequestInformationType
     */
    public $PriceRequestInformation;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - documentation: Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TravelerInfoSummary_TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The SpecificPTC_Indicator
     * Meta information extracted from the WSDL
     * - documentation: If true, this request is for a specific PTC and only fares applicable to that PTC will be checked and returned. It is the same as XOFares flag in Intellisell request.
     * - use: optional
     * @var bool
     */
    public $SpecificPTC_Indicator;
    /**
     * Constructor method for TravelerInfoSummaryType
     * @uses TravelerInfoSummaryType::setSeatsRequested()
     * @uses TravelerInfoSummaryType::setAirTravelerAvail()
     * @uses TravelerInfoSummaryType::setPriceRequestInformation()
     * @uses TravelerInfoSummaryType::setTPA_Extensions()
     * @uses TravelerInfoSummaryType::setSpecificPTC_Indicator()
     * @param int[] $seatsRequested
     * @param \SabreSoap\StructType\TravelerInformationType[] $airTravelerAvail
     * @param \SabreSoap\StructType\PriceRequestInformationType $priceRequestInformation
     * @param \SabreSoap\StructType\TravelerInfoSummary_TPA_ExtensionsType $tPA_Extensions
     * @param bool $specificPTC_Indicator
     */
    public function __construct(array $seatsRequested = array(), array $airTravelerAvail = array(), \SabreSoap\StructType\PriceRequestInformationType $priceRequestInformation = null, \SabreSoap\StructType\TravelerInfoSummary_TPA_ExtensionsType $tPA_Extensions = null, $specificPTC_Indicator = null)
    {
        $this
            ->setSeatsRequested($seatsRequested)
            ->setAirTravelerAvail($airTravelerAvail)
            ->setPriceRequestInformation($priceRequestInformation)
            ->setTPA_Extensions($tPA_Extensions)
            ->setSpecificPTC_Indicator($specificPTC_Indicator);
    }
    /**
     * Get SeatsRequested value
     * @return int[]|null
     */
    public function getSeatsRequested()
    {
        return $this->SeatsRequested;
    }
    /**
     * Set SeatsRequested value
     * @param int[] $seatsRequested
     * @return \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public function setSeatsRequested(array $seatsRequested = array())
    {
        $this->SeatsRequested = $seatsRequested;
        return $this;
    }
    /**
     * Add item to SeatsRequested value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public function addToSeatsRequested($item)
    {
        $this->SeatsRequested[] = $item;
        return $this;
    }
    /**
     * Get AirTravelerAvail value
     * @return \SabreSoap\StructType\TravelerInformationType[]|null
     */
    public function getAirTravelerAvail()
    {
        return $this->AirTravelerAvail;
    }
    /**
     * Set AirTravelerAvail value
     * @param \SabreSoap\StructType\TravelerInformationType[] $airTravelerAvail
     * @return \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public function setAirTravelerAvail(array $airTravelerAvail = array())
    {
        $this->AirTravelerAvail = $airTravelerAvail;
        return $this;
    }
    /**
     * Add item to AirTravelerAvail value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\TravelerInformationType $item
     * @return \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public function addToAirTravelerAvail(\SabreSoap\StructType\TravelerInformationType $item)
    {
        $this->AirTravelerAvail[] = $item;
        return $this;
    }
    /**
     * Get PriceRequestInformation value
     * @return \SabreSoap\StructType\PriceRequestInformationType|null
     */
    public function getPriceRequestInformation()
    {
        return $this->PriceRequestInformation;
    }
    /**
     * Set PriceRequestInformation value
     * @param \SabreSoap\StructType\PriceRequestInformationType $priceRequestInformation
     * @return \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public function setPriceRequestInformation(\SabreSoap\StructType\PriceRequestInformationType $priceRequestInformation = null)
    {
        $this->PriceRequestInformation = $priceRequestInformation;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TravelerInfoSummary_TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TravelerInfoSummary_TPA_ExtensionsType $tPA_Extensions
     * @return \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TravelerInfoSummary_TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get SpecificPTC_Indicator value
     * @return bool|null
     */
    public function getSpecificPTC_Indicator()
    {
        return $this->SpecificPTC_Indicator;
    }
    /**
     * Set SpecificPTC_Indicator value
     * @param bool $specificPTC_Indicator
     * @return \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public function setSpecificPTC_Indicator($specificPTC_Indicator = null)
    {
        $this->SpecificPTC_Indicator = $specificPTC_Indicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
