<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransformType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class TransformType extends AbstractStructBase
{
    /**
     * The Algorithm
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Algorithm;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The XPath
     * Meta information extracted from the WSDL
     * - choice: XPath |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var string
     */
    public $XPath;
    /**
     * Constructor method for TransformType
     * @uses TransformType::setAlgorithm()
     * @uses TransformType::setAny()
     * @uses TransformType::setXPath()
     * @param string $algorithm
     * @param \DOMDocument $any
     * @param string $xPath
     */
    public function __construct($algorithm = null, \DOMDocument $any = null, $xPath = null)
    {
        $this
            ->setAlgorithm($algorithm)
            ->setAny($any)
            ->setXPath($xPath);
    }
    /**
     * Get Algorithm value
     * @return string
     */
    public function getAlgorithm()
    {
        return $this->Algorithm;
    }
    /**
     * Set Algorithm value
     * @param string $algorithm
     * @return \SabreSoap\StructType\TransformType
     */
    public function setAlgorithm($algorithm = null)
    {
        $this->Algorithm = $algorithm;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\TransformType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get XPath value
     * @return string|null
     */
    public function getXPath()
    {
        return isset($this->XPath) ? $this->XPath : null;
    }
    /**
     * Set XPath value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $xPath
     * @return \SabreSoap\StructType\TransformType
     */
    public function setXPath($xPath = null)
    {
        if (is_null($xPath) || (is_array($xPath) && empty($xPath))) {
            unset($this->XPath);
        } else {
            $this->XPath = $xPath;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\TransformType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
