<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taxes StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a collection of Taxes | Specify Taxes (/TX)
 * - minOccurs: 0
 * @subpackage Structs
 */
class Taxes extends AbstractStructBase
{
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: Any individual tax applied to the fare | Specify tax amount and code.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TaxCodeAmountType
     */
    public $Tax;
    /**
     * The FareComponentsTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareComponentsTaxes
     */
    public $FareComponentsTaxes;
    /**
     * The LegsTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\LegsTaxes
     */
    public $LegsTaxes;
    /**
     * The TotalTax
     * Meta information extracted from the WSDL
     * - documentation: Total (summary) of taxes applied to the fare
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CurrencyAmountType
     */
    public $TotalTax;
    /**
     * Constructor method for Taxes
     * @uses Taxes::setTax()
     * @uses Taxes::setFareComponentsTaxes()
     * @uses Taxes::setLegsTaxes()
     * @uses Taxes::setTotalTax()
     * @param \SabreSoap\StructType\TaxCodeAmountType $tax
     * @param \SabreSoap\StructType\FareComponentsTaxes $fareComponentsTaxes
     * @param \SabreSoap\StructType\LegsTaxes $legsTaxes
     * @param \SabreSoap\StructType\CurrencyAmountType $totalTax
     */
    public function __construct(\SabreSoap\StructType\TaxCodeAmountType $tax = null, \SabreSoap\StructType\FareComponentsTaxes $fareComponentsTaxes = null, \SabreSoap\StructType\LegsTaxes $legsTaxes = null, \SabreSoap\StructType\CurrencyAmountType $totalTax = null)
    {
        $this
            ->setTax($tax)
            ->setFareComponentsTaxes($fareComponentsTaxes)
            ->setLegsTaxes($legsTaxes)
            ->setTotalTax($totalTax);
    }
    /**
     * Get Tax value
     * @return \SabreSoap\StructType\TaxCodeAmountType|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @param \SabreSoap\StructType\TaxCodeAmountType $tax
     * @return \SabreSoap\StructType\Taxes
     */
    public function setTax(\SabreSoap\StructType\TaxCodeAmountType $tax = null)
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Get FareComponentsTaxes value
     * @return \SabreSoap\StructType\FareComponentsTaxes|null
     */
    public function getFareComponentsTaxes()
    {
        return $this->FareComponentsTaxes;
    }
    /**
     * Set FareComponentsTaxes value
     * @param \SabreSoap\StructType\FareComponentsTaxes $fareComponentsTaxes
     * @return \SabreSoap\StructType\Taxes
     */
    public function setFareComponentsTaxes(\SabreSoap\StructType\FareComponentsTaxes $fareComponentsTaxes = null)
    {
        $this->FareComponentsTaxes = $fareComponentsTaxes;
        return $this;
    }
    /**
     * Get LegsTaxes value
     * @return \SabreSoap\StructType\LegsTaxes|null
     */
    public function getLegsTaxes()
    {
        return $this->LegsTaxes;
    }
    /**
     * Set LegsTaxes value
     * @param \SabreSoap\StructType\LegsTaxes $legsTaxes
     * @return \SabreSoap\StructType\Taxes
     */
    public function setLegsTaxes(\SabreSoap\StructType\LegsTaxes $legsTaxes = null)
    {
        $this->LegsTaxes = $legsTaxes;
        return $this;
    }
    /**
     * Get TotalTax value
     * @return \SabreSoap\StructType\CurrencyAmountType|null
     */
    public function getTotalTax()
    {
        return $this->TotalTax;
    }
    /**
     * Set TotalTax value
     * @param \SabreSoap\StructType\CurrencyAmountType $totalTax
     * @return \SabreSoap\StructType\Taxes
     */
    public function setTotalTax(\SabreSoap\StructType\CurrencyAmountType $totalTax = null)
    {
        $this->TotalTax = $totalTax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Taxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
