<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusRequest StructType
 * @subpackage Structs
 */
class StatusRequest extends AbstractStructBase
{
    /**
     * The RefToMessageId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:RefToMessageId
     * @var string
     */
    public $RefToMessageId;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for StatusRequest
     * @uses StatusRequest::setRefToMessageId()
     * @uses StatusRequest::setAny()
     * @uses StatusRequest::setId()
     * @uses StatusRequest::setVersion()
     * @param string $refToMessageId
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct($refToMessageId = null, \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setRefToMessageId($refToMessageId)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get RefToMessageId value
     * @return string|null
     */
    public function getRefToMessageId()
    {
        return $this->RefToMessageId;
    }
    /**
     * Set RefToMessageId value
     * @param string $refToMessageId
     * @return \SabreSoap\StructType\StatusRequest
     */
    public function setRefToMessageId($refToMessageId = null)
    {
        $this->RefToMessageId = $refToMessageId;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\StatusRequest
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabreSoap\StructType\StatusRequest
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabreSoap\StructType\StatusRequest
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\StatusRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
