<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignaturePropertiesType StructType
 * @subpackage Structs
 */
class SignaturePropertiesType extends AbstractStructBase
{
    /**
     * The SignatureProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:SignatureProperty
     * @var \SabreSoap\StructType\SignaturePropertyType[]
     */
    public $SignatureProperty;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignaturePropertiesType
     * @uses SignaturePropertiesType::setSignatureProperty()
     * @uses SignaturePropertiesType::setId()
     * @param \SabreSoap\StructType\SignaturePropertyType[] $signatureProperty
     * @param string $id
     */
    public function __construct(array $signatureProperty = array(), $id = null)
    {
        $this
            ->setSignatureProperty($signatureProperty)
            ->setId($id);
    }
    /**
     * Get SignatureProperty value
     * @return \SabreSoap\StructType\SignaturePropertyType[]|null
     */
    public function getSignatureProperty()
    {
        return $this->SignatureProperty;
    }
    /**
     * Set SignatureProperty value
     * @param \SabreSoap\StructType\SignaturePropertyType[] $signatureProperty
     * @return \SabreSoap\StructType\SignaturePropertiesType
     */
    public function setSignatureProperty(array $signatureProperty = array())
    {
        $this->SignatureProperty = $signatureProperty;
        return $this;
    }
    /**
     * Add item to SignatureProperty value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\SignaturePropertyType $item
     * @return \SabreSoap\StructType\SignaturePropertiesType
     */
    public function addToSignatureProperty(\SabreSoap\StructType\SignaturePropertyType $item)
    {
        $this->SignatureProperty[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabreSoap\StructType\SignaturePropertiesType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\SignaturePropertiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
