<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Score StructType
 * @subpackage Structs
 */
class Score extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Value;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Carrier;
    /**
     * Constructor method for Score
     * @uses Score::setValue()
     * @uses Score::setCarrier()
     * @param int $value
     * @param string $carrier
     */
    public function __construct($value = null, $carrier = null)
    {
        $this
            ->setValue($value)
            ->setCarrier($carrier);
    }
    /**
     * Get Value value
     * @return int
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \SabreSoap\StructType\Score
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \SabreSoap\StructType\Score
     */
    public function setCarrier($carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Score
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
