<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoutingLegType StructType
 * Meta information extracted from the WSDL
 * - documentation: Definition of individual routing legs, at least one leg must be present.
 * @subpackage Structs
 */
class RoutingLegType extends AbstractStructBase
{
    /**
     * The InboundCarrier
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: [A-Z0-9][A-Z][A-Z0-9]?
     * @var string[]
     */
    public $InboundCarrier;
    /**
     * The ConnectPoint
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: [A-Z]{3,5}
     * @var string[]
     */
    public $ConnectPoint;
    /**
     * Constructor method for RoutingLegType
     * @uses RoutingLegType::setInboundCarrier()
     * @uses RoutingLegType::setConnectPoint()
     * @param string[] $inboundCarrier
     * @param string[] $connectPoint
     */
    public function __construct(array $inboundCarrier = array(), array $connectPoint = array())
    {
        $this
            ->setInboundCarrier($inboundCarrier)
            ->setConnectPoint($connectPoint);
    }
    /**
     * Get InboundCarrier value
     * @return string[]|null
     */
    public function getInboundCarrier()
    {
        return $this->InboundCarrier;
    }
    /**
     * Set InboundCarrier value
     * @param string[] $inboundCarrier
     * @return \SabreSoap\StructType\RoutingLegType
     */
    public function setInboundCarrier(array $inboundCarrier = array())
    {
        $this->InboundCarrier = $inboundCarrier;
        return $this;
    }
    /**
     * Add item to InboundCarrier value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\RoutingLegType
     */
    public function addToInboundCarrier($item)
    {
        $this->InboundCarrier[] = $item;
        return $this;
    }
    /**
     * Get ConnectPoint value
     * @return string[]|null
     */
    public function getConnectPoint()
    {
        return $this->ConnectPoint;
    }
    /**
     * Set ConnectPoint value
     * @param string[] $connectPoint
     * @return \SabreSoap\StructType\RoutingLegType
     */
    public function setConnectPoint(array $connectPoint = array())
    {
        $this->ConnectPoint = $connectPoint;
        return $this;
    }
    /**
     * Add item to ConnectPoint value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\RoutingLegType
     */
    public function addToConnectPoint($item)
    {
        $this->ConnectPoint[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\RoutingLegType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
