<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationType StructType
 * @subpackage Structs
 */
class ReservationType extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Reservation status
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The RealStatus
     * Meta information extracted from the WSDL
     * - documentation: Real reservation status
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - use: optional
     * @var string
     */
    public $RealStatus;
    /**
     * Constructor method for ReservationType
     * @uses ReservationType::setStatus()
     * @uses ReservationType::setRealStatus()
     * @param string $status
     * @param string $realStatus
     */
    public function __construct($status = null, $realStatus = null)
    {
        $this
            ->setStatus($status)
            ->setRealStatus($realStatus);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \SabreSoap\StructType\ReservationType
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get RealStatus value
     * @return string|null
     */
    public function getRealStatus()
    {
        return $this->RealStatus;
    }
    /**
     * Set RealStatus value
     * @param string $realStatus
     * @return \SabreSoap\StructType\ReservationType
     */
    public function setRealStatus($realStatus = null)
    {
        $this->RealStatus = $realStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
