<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Range StructType
 * Meta information extracted from the WSDL
 * - documentation: Either all Range elements shall contain attribute Options or none. Ranges shall not overlap.
 * @subpackage Structs
 */
class Range extends AbstractStructBase
{
    /**
     * The Begin
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: ([0-1]?[0-9]|2[0-3]):[0-5][0-9]
     * - use: required
     * @var string
     */
    public $Begin;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: ([0-1]?[0-9]|2[0-3]):[0-5][0-9]
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [1-9][0-9]*|0%?|100%|[1-9][0-9]?%
     * - use: optional
     * @var string
     */
    public $Options;
    /**
     * Constructor method for Range
     * @uses Range::setBegin()
     * @uses Range::setEnd()
     * @uses Range::setOptions()
     * @param string $begin
     * @param string $end
     * @param string $options
     */
    public function __construct($begin = null, $end = null, $options = null)
    {
        $this
            ->setBegin($begin)
            ->setEnd($end)
            ->setOptions($options);
    }
    /**
     * Get Begin value
     * @return string
     */
    public function getBegin()
    {
        return $this->Begin;
    }
    /**
     * Set Begin value
     * @param string $begin
     * @return \SabreSoap\StructType\Range
     */
    public function setBegin($begin = null)
    {
        $this->Begin = $begin;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \SabreSoap\StructType\Range
     */
    public function setEnd($end = null)
    {
        $this->End = $end;
        return $this;
    }
    /**
     * Get Options value
     * @return string|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @param string $options
     * @return \SabreSoap\StructType\Range
     */
    public function setOptions($options = null)
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Range
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
