<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromoOffer StructType
 * Meta information extracted from the WSDL
 * - documentation: Promotional offer
 * @subpackage Structs
 */
class PromoOffer extends AbstractStructBase
{
    /**
     * The PromoID
     * Meta information extracted from the WSDL
     * - documentation: Promotional offer identifier
     * @var string
     */
    public $PromoID;
    /**
     * The CorpID
     * Meta information extracted from the WSDL
     * - documentation: Airline identifier.
     * - use: optional
     * @var string
     */
    public $CorpID;
    /**
     * The ContentID
     * Meta information extracted from the WSDL
     * - documentation: This information comes from Fare Notes Rule fired and is taken by Travelocity to look up detailed data on their database to put on the website.
     * @var string
     */
    public $ContentID;
    /**
     * Constructor method for PromoOffer
     * @uses PromoOffer::setPromoID()
     * @uses PromoOffer::setCorpID()
     * @uses PromoOffer::setContentID()
     * @param string $promoID
     * @param string $corpID
     * @param string $contentID
     */
    public function __construct($promoID = null, $corpID = null, $contentID = null)
    {
        $this
            ->setPromoID($promoID)
            ->setCorpID($corpID)
            ->setContentID($contentID);
    }
    /**
     * Get PromoID value
     * @return string|null
     */
    public function getPromoID()
    {
        return $this->PromoID;
    }
    /**
     * Set PromoID value
     * @param string $promoID
     * @return \SabreSoap\StructType\PromoOffer
     */
    public function setPromoID($promoID = null)
    {
        $this->PromoID = $promoID;
        return $this;
    }
    /**
     * Get CorpID value
     * @return string|null
     */
    public function getCorpID()
    {
        return $this->CorpID;
    }
    /**
     * Set CorpID value
     * @param string $corpID
     * @return \SabreSoap\StructType\PromoOffer
     */
    public function setCorpID($corpID = null)
    {
        $this->CorpID = $corpID;
        return $this;
    }
    /**
     * Get ContentID value
     * @return string|null
     */
    public function getContentID()
    {
        return $this->ContentID;
    }
    /**
     * Set ContentID value
     * @param string $contentID
     * @return \SabreSoap\StructType\PromoOffer
     */
    public function setContentID($contentID = null)
    {
        $this->ContentID = $contentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\PromoOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
