<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessingMessageType StructType
 * Meta information extracted from the WSDL
 * - documentation: Message generated per for particular date and leg
 * @subpackage Structs
 */
class ProcessingMessageType extends AbstractStructBase
{
    /**
     * The PricingSource
     * Meta information extracted from the WSDL
     * - documentation: Pricing source. | It can be used to indicate whether the fare is public or private.
     * - base: xs:string
     * - pattern: [0-9A-Z_]{1,13}
     * - use: required
     * @var string
     */
    public $PricingSource;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - documentation: Message text
     * - use: required
     * @var string
     */
    public $Message;
    /**
     * Constructor method for ProcessingMessageType
     * @uses ProcessingMessageType::setPricingSource()
     * @uses ProcessingMessageType::setMessage()
     * @param string $pricingSource
     * @param string $message
     */
    public function __construct($pricingSource = null, $message = null)
    {
        $this
            ->setPricingSource($pricingSource)
            ->setMessage($message);
    }
    /**
     * Get PricingSource value
     * @return string
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \SabreSoap\StructType\ProcessingMessageType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get Message value
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \SabreSoap\StructType\ProcessingMessageType
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ProcessingMessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
