<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Priority StructType
 * Meta information extracted from the WSDL
 * - documentation: This element governs how flights are returned. A user can uses a priority of 1-4 to make this determination.
 * @subpackage Structs
 */
class Priority extends AbstractStructBase
{
    /**
     * The Price
     * @var \SabreSoap\StructType\Price
     */
    public $Price;
    /**
     * The DirectFlights
     * @var \SabreSoap\StructType\DirectFlights
     */
    public $DirectFlights;
    /**
     * The Time
     * @var \SabreSoap\StructType\Time
     */
    public $Time;
    /**
     * The Vendor
     * @var \SabreSoap\StructType\Vendor
     */
    public $Vendor;
    /**
     * Constructor method for Priority
     * @uses Priority::setPrice()
     * @uses Priority::setDirectFlights()
     * @uses Priority::setTime()
     * @uses Priority::setVendor()
     * @param \SabreSoap\StructType\Price $price
     * @param \SabreSoap\StructType\DirectFlights $directFlights
     * @param \SabreSoap\StructType\Time $time
     * @param \SabreSoap\StructType\Vendor $vendor
     */
    public function __construct(\SabreSoap\StructType\Price $price = null, \SabreSoap\StructType\DirectFlights $directFlights = null, \SabreSoap\StructType\Time $time = null, \SabreSoap\StructType\Vendor $vendor = null)
    {
        $this
            ->setPrice($price)
            ->setDirectFlights($directFlights)
            ->setTime($time)
            ->setVendor($vendor);
    }
    /**
     * Get Price value
     * @return \SabreSoap\StructType\Price|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \SabreSoap\StructType\Price $price
     * @return \SabreSoap\StructType\Priority
     */
    public function setPrice(\SabreSoap\StructType\Price $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get DirectFlights value
     * @return \SabreSoap\StructType\DirectFlights|null
     */
    public function getDirectFlights()
    {
        return $this->DirectFlights;
    }
    /**
     * Set DirectFlights value
     * @param \SabreSoap\StructType\DirectFlights $directFlights
     * @return \SabreSoap\StructType\Priority
     */
    public function setDirectFlights(\SabreSoap\StructType\DirectFlights $directFlights = null)
    {
        $this->DirectFlights = $directFlights;
        return $this;
    }
    /**
     * Get Time value
     * @return \SabreSoap\StructType\Time|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param \SabreSoap\StructType\Time $time
     * @return \SabreSoap\StructType\Priority
     */
    public function setTime(\SabreSoap\StructType\Time $time = null)
    {
        $this->Time = $time;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \SabreSoap\StructType\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \SabreSoap\StructType\Vendor $vendor
     * @return \SabreSoap\StructType\Priority
     */
    public function setVendor(\SabreSoap\StructType\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Priority
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
