<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItineraries StructType
 * Meta information extracted from the WSDL
 * - documentation: Low Fare priced itineraries container.
 * @subpackage Structs
 */
class PricedItineraries extends AbstractStructBase
{
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The PricedItinerary
     * Meta information extracted from the WSDL
     * - documentation: Successfull Low Fare priced itineraries in response to a Low Fare Search request.
     * - maxOccurs: unbounded
     * @var \SabreSoap\StructType\PricedItineraryType[]
     */
    public $PricedItinerary;
    /**
     * Constructor method for PricedItineraries
     * @uses PricedItineraries::setTPA_Extensions()
     * @uses PricedItineraries::setPricedItinerary()
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param \SabreSoap\StructType\PricedItineraryType[] $pricedItinerary
     */
    public function __construct(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, array $pricedItinerary = array())
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setPricedItinerary($pricedItinerary);
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\PricedItineraries
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PricedItinerary value
     * @return \SabreSoap\StructType\PricedItineraryType[]|null
     */
    public function getPricedItinerary()
    {
        return $this->PricedItinerary;
    }
    /**
     * Set PricedItinerary value
     * @param \SabreSoap\StructType\PricedItineraryType[] $pricedItinerary
     * @return \SabreSoap\StructType\PricedItineraries
     */
    public function setPricedItinerary(array $pricedItinerary = array())
    {
        $this->PricedItinerary = $pricedItinerary;
        return $this;
    }
    /**
     * Add item to PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\PricedItineraryType $item
     * @return \SabreSoap\StructType\PricedItineraries
     */
    public function addToPricedItinerary(\SabreSoap\StructType\PricedItineraryType $item)
    {
        $this->PricedItinerary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\PricedItineraries
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
