<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to identify geospatial postion of the requesting entity.
 * @subpackage Structs
 */
class PositionType extends AbstractStructBase
{
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Longitude;
    /**
     * The Altitude
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Altitude;
    /**
     * Constructor method for PositionType
     * @uses PositionType::setLatitude()
     * @uses PositionType::setLongitude()
     * @uses PositionType::setAltitude()
     * @param string $latitude
     * @param string $longitude
     * @param string $altitude
     */
    public function __construct($latitude = null, $longitude = null, $altitude = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setAltitude($altitude);
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \SabreSoap\StructType\PositionType
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \SabreSoap\StructType\PositionType
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Altitude value
     * @return string|null
     */
    public function getAltitude()
    {
        return $this->Altitude;
    }
    /**
     * Set Altitude value
     * @param string $altitude
     * @return \SabreSoap\StructType\PositionType
     */
    public function setAltitude($altitude = null)
    {
        $this->Altitude = $altitude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\PositionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
