<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlusUpType StructType
 * @subpackage Structs
 */
class PlusUpType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The OriginCity
     * Meta information extracted from the WSDL
     * - documentation: Origin City | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: required
     * @var string
     */
    public $OriginCity;
    /**
     * The DestinationCity
     * Meta information extracted from the WSDL
     * - documentation: Destination City | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: required
     * @var string
     */
    public $DestinationCity;
    /**
     * The FareOriginCity
     * Meta information extracted from the WSDL
     * - documentation: Fare Origin City | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $FareOriginCity;
    /**
     * The FareDestinationCity
     * Meta information extracted from the WSDL
     * - documentation: Fare Destination City | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $FareDestinationCity;
    /**
     * The ViaCity
     * Meta information extracted from the WSDL
     * - documentation: Via City | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - use: optional
     * @var string
     */
    public $ViaCity;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - documentation: Message
     * - use: optional
     * @var string
     */
    public $Message;
    /**
     * The CountryOfPayment
     * Meta information extracted from the WSDL
     * - documentation: Country of payment | 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - use: optional
     * @var string
     */
    public $CountryOfPayment;
    /**
     * Constructor method for PlusUpType
     * @uses PlusUpType::setAmount()
     * @uses PlusUpType::setOriginCity()
     * @uses PlusUpType::setDestinationCity()
     * @uses PlusUpType::setFareOriginCity()
     * @uses PlusUpType::setFareDestinationCity()
     * @uses PlusUpType::setViaCity()
     * @uses PlusUpType::setMessage()
     * @uses PlusUpType::setCountryOfPayment()
     * @param float $amount
     * @param string $originCity
     * @param string $destinationCity
     * @param string $fareOriginCity
     * @param string $fareDestinationCity
     * @param string $viaCity
     * @param string $message
     * @param string $countryOfPayment
     */
    public function __construct($amount = null, $originCity = null, $destinationCity = null, $fareOriginCity = null, $fareDestinationCity = null, $viaCity = null, $message = null, $countryOfPayment = null)
    {
        $this
            ->setAmount($amount)
            ->setOriginCity($originCity)
            ->setDestinationCity($destinationCity)
            ->setFareOriginCity($fareOriginCity)
            ->setFareDestinationCity($fareDestinationCity)
            ->setViaCity($viaCity)
            ->setMessage($message)
            ->setCountryOfPayment($countryOfPayment);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SabreSoap\StructType\PlusUpType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get OriginCity value
     * @return string
     */
    public function getOriginCity()
    {
        return $this->OriginCity;
    }
    /**
     * Set OriginCity value
     * @param string $originCity
     * @return \SabreSoap\StructType\PlusUpType
     */
    public function setOriginCity($originCity = null)
    {
        $this->OriginCity = $originCity;
        return $this;
    }
    /**
     * Get DestinationCity value
     * @return string
     */
    public function getDestinationCity()
    {
        return $this->DestinationCity;
    }
    /**
     * Set DestinationCity value
     * @param string $destinationCity
     * @return \SabreSoap\StructType\PlusUpType
     */
    public function setDestinationCity($destinationCity = null)
    {
        $this->DestinationCity = $destinationCity;
        return $this;
    }
    /**
     * Get FareOriginCity value
     * @return string|null
     */
    public function getFareOriginCity()
    {
        return $this->FareOriginCity;
    }
    /**
     * Set FareOriginCity value
     * @param string $fareOriginCity
     * @return \SabreSoap\StructType\PlusUpType
     */
    public function setFareOriginCity($fareOriginCity = null)
    {
        $this->FareOriginCity = $fareOriginCity;
        return $this;
    }
    /**
     * Get FareDestinationCity value
     * @return string|null
     */
    public function getFareDestinationCity()
    {
        return $this->FareDestinationCity;
    }
    /**
     * Set FareDestinationCity value
     * @param string $fareDestinationCity
     * @return \SabreSoap\StructType\PlusUpType
     */
    public function setFareDestinationCity($fareDestinationCity = null)
    {
        $this->FareDestinationCity = $fareDestinationCity;
        return $this;
    }
    /**
     * Get ViaCity value
     * @return string|null
     */
    public function getViaCity()
    {
        return $this->ViaCity;
    }
    /**
     * Set ViaCity value
     * @param string $viaCity
     * @return \SabreSoap\StructType\PlusUpType
     */
    public function setViaCity($viaCity = null)
    {
        $this->ViaCity = $viaCity;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \SabreSoap\StructType\PlusUpType
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get CountryOfPayment value
     * @return string|null
     */
    public function getCountryOfPayment()
    {
        return $this->CountryOfPayment;
    }
    /**
     * Set CountryOfPayment value
     * @param string $countryOfPayment
     * @return \SabreSoap\StructType\PlusUpType
     */
    public function setCountryOfPayment($countryOfPayment = null)
    {
        $this->CountryOfPayment = $countryOfPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\PlusUpType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
