<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonNameType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is an XML Schema representing the OTA Person Name object.
 * @subpackage Structs
 */
class PersonNameType extends AbstractStructBase
{
    /**
     * The NamePrefix
     * Meta information extracted from the WSDL
     * - documentation: Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.) | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $NamePrefix;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - documentation: Given name, first name or names | Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - maxOccurs: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $GivenName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: Person's middle name | Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $MiddleName;
    /**
     * The SurnamePrefix
     * Meta information extracted from the WSDL
     * - documentation: e.g "van der", "von", "de" | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurnamePrefix;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - documentation: Family name, last name. | Used for Character Strings, length 1 to 64
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $Surname;
    /**
     * The NameSuffix
     * Meta information extracted from the WSDL
     * - documentation: Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.). | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $NameSuffix;
    /**
     * The NameTitle
     * Meta information extracted from the WSDL
     * - documentation: Degree or honors (e.g., Ph.D., M.D.) | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - maxOccurs: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $NameTitle;
    /**
     * The NameType
     * Meta information extracted from the WSDL
     * - documentation: Type of name of the individual, such as former, nickname, alternate or alias name. Refer to OTA Code List Name Type (NAM). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - use: optional
     * @var string
     */
    public $NameType;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for PersonNameType
     * @uses PersonNameType::setNamePrefix()
     * @uses PersonNameType::setGivenName()
     * @uses PersonNameType::setMiddleName()
     * @uses PersonNameType::setSurnamePrefix()
     * @uses PersonNameType::setSurname()
     * @uses PersonNameType::setNameSuffix()
     * @uses PersonNameType::setNameTitle()
     * @uses PersonNameType::setNameType()
     * @uses PersonNameType::setShareSynchInd()
     * @uses PersonNameType::setShareMarketInd()
     * @param string[] $namePrefix
     * @param string[] $givenName
     * @param string[] $middleName
     * @param string $surnamePrefix
     * @param string $surname
     * @param string[] $nameSuffix
     * @param string[] $nameTitle
     * @param string $nameType
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct(array $namePrefix = array(), array $givenName = array(), array $middleName = array(), $surnamePrefix = null, $surname = null, array $nameSuffix = array(), array $nameTitle = array(), $nameType = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setNamePrefix($namePrefix)
            ->setGivenName($givenName)
            ->setMiddleName($middleName)
            ->setSurnamePrefix($surnamePrefix)
            ->setSurname($surname)
            ->setNameSuffix($nameSuffix)
            ->setNameTitle($nameTitle)
            ->setNameType($nameType)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get NamePrefix value
     * @return string[]|null
     */
    public function getNamePrefix()
    {
        return $this->NamePrefix;
    }
    /**
     * Set NamePrefix value
     * @param string[] $namePrefix
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setNamePrefix(array $namePrefix = array())
    {
        $this->NamePrefix = $namePrefix;
        return $this;
    }
    /**
     * Add item to NamePrefix value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function addToNamePrefix($item)
    {
        $this->NamePrefix[] = $item;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @param string[] $givenName
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setGivenName(array $givenName = array())
    {
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function addToGivenName($item)
    {
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string[] $middleName
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setMiddleName(array $middleName = array())
    {
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function addToMiddleName($item)
    {
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get SurnamePrefix value
     * @return string|null
     */
    public function getSurnamePrefix()
    {
        return $this->SurnamePrefix;
    }
    /**
     * Set SurnamePrefix value
     * @param string $surnamePrefix
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setSurnamePrefix($surnamePrefix = null)
    {
        $this->SurnamePrefix = $surnamePrefix;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setSurname($surname = null)
    {
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return string[]|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * Set NameSuffix value
     * @param string[] $nameSuffix
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setNameSuffix(array $nameSuffix = array())
    {
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Add item to NameSuffix value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function addToNameSuffix($item)
    {
        $this->NameSuffix[] = $item;
        return $this;
    }
    /**
     * Get NameTitle value
     * @return string[]|null
     */
    public function getNameTitle()
    {
        return $this->NameTitle;
    }
    /**
     * Set NameTitle value
     * @param string[] $nameTitle
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setNameTitle(array $nameTitle = array())
    {
        $this->NameTitle = $nameTitle;
        return $this;
    }
    /**
     * Add item to NameTitle value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function addToNameTitle($item)
    {
        $this->NameTitle[] = $item;
        return $this;
    }
    /**
     * Get NameType value
     * @return string|null
     */
    public function getNameType()
    {
        return $this->NameType;
    }
    /**
     * Set NameType value
     * @param string $nameType
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setNameType($nameType = null)
    {
        $this->NameType = $nameType;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \SabreSoap\StructType\PersonNameType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\PersonNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
