<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerTypeQuantityType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies a PTC (Passenger Type Code) and the associated number of PTC's - for use in specifying passenger lists.
 * @subpackage Structs
 */
class PassengerTypeQuantityType extends TravelerCountType
{
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The Changeable
     * Meta information extracted from the WSDL
     * - default: true
     * - use: optional
     * @var bool
     */
    public $Changeable;
    /**
     * The Index
     * Meta information extracted from the WSDL
     * - documentation: Allows to identify which one of requested passengers this solution relates to.
     * @var int
     */
    public $Index;
    /**
     * Constructor method for PassengerTypeQuantityType
     * @uses PassengerTypeQuantityType::setTPA_Extensions()
     * @uses PassengerTypeQuantityType::setChangeable()
     * @uses PassengerTypeQuantityType::setIndex()
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param bool $changeable
     * @param int $index
     */
    public function __construct(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, $changeable = true, $index = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setChangeable($changeable)
            ->setIndex($index);
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\PassengerTypeQuantityType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Changeable value
     * @return bool|null
     */
    public function getChangeable()
    {
        return $this->Changeable;
    }
    /**
     * Set Changeable value
     * @param bool $changeable
     * @return \SabreSoap\StructType\PassengerTypeQuantityType
     */
    public function setChangeable($changeable = true)
    {
        $this->Changeable = $changeable;
        return $this;
    }
    /**
     * Get Index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param int $index
     * @return \SabreSoap\StructType\PassengerTypeQuantityType
     */
    public function setIndex($index = null)
    {
        $this->Index = $index;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\PassengerTypeQuantityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
