<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTCFareBreakdownType StructType
 * Meta information extracted from the WSDL
 * - documentation: Per passenger type code pricing for this itinerary. Set if fareBreakdown was requested.
 * @subpackage Structs
 */
class PTCFareBreakdownType extends AbstractStructBase
{
    /**
     * The PassengerTypeQuantity
     * Meta information extracted from the WSDL
     * - documentation: Number of individuals traveling under this PTC
     * @var \SabreSoap\StructType\PassengerTypeQuantityType
     */
    public $PassengerTypeQuantity;
    /**
     * The FareBasisCodes
     * @var \SabreSoap\StructType\FareBasisCodes
     */
    public $FareBasisCodes;
    /**
     * The PassengerFare
     * Meta information extracted from the WSDL
     * - documentation: The total passenger fare with cost breakdown.
     * @var \SabreSoap\StructType\FareType
     */
    public $PassengerFare;
    /**
     * The Endorsements
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Endorsements
     */
    public $Endorsements;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The FareInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FareInfos
     */
    public $FareInfos;
    /**
     * The PricingSource
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the fare is public or private. | It can be used to indicate whether the fare is public or private.
     * - base: xs:string
     * - pattern: [0-9A-Z_]{1,13}
     * - use: optional
     * @var string
     */
    public $PricingSource;
    /**
     * The PrivateFareType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 1
     * @var string
     */
    public $PrivateFareType;
    /**
     * The LastTicketDate
     * Meta information extracted from the WSDL
     * - documentation: Last day to ticket. | Allows for the specification of a date time or just time.
     * - union: string | time
     * @var string
     */
    public $LastTicketDate;
    /**
     * The PreviousExchangeDate
     * Meta information extracted from the WSDL
     * - documentation: Previous Exchange Date
     * @var string
     */
    public $PreviousExchangeDate;
    /**
     * The ReissueExchange
     * @var int
     */
    public $ReissueExchange;
    /**
     * Constructor method for PTCFareBreakdownType
     * @uses PTCFareBreakdownType::setPassengerTypeQuantity()
     * @uses PTCFareBreakdownType::setFareBasisCodes()
     * @uses PTCFareBreakdownType::setPassengerFare()
     * @uses PTCFareBreakdownType::setEndorsements()
     * @uses PTCFareBreakdownType::setTPA_Extensions()
     * @uses PTCFareBreakdownType::setFareInfos()
     * @uses PTCFareBreakdownType::setPricingSource()
     * @uses PTCFareBreakdownType::setPrivateFareType()
     * @uses PTCFareBreakdownType::setLastTicketDate()
     * @uses PTCFareBreakdownType::setPreviousExchangeDate()
     * @uses PTCFareBreakdownType::setReissueExchange()
     * @param \SabreSoap\StructType\PassengerTypeQuantityType $passengerTypeQuantity
     * @param \SabreSoap\StructType\FareBasisCodes $fareBasisCodes
     * @param \SabreSoap\StructType\FareType $passengerFare
     * @param \SabreSoap\StructType\Endorsements $endorsements
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param \SabreSoap\StructType\FareInfos $fareInfos
     * @param string $pricingSource
     * @param string $privateFareType
     * @param string $lastTicketDate
     * @param string $previousExchangeDate
     * @param int $reissueExchange
     */
    public function __construct(\SabreSoap\StructType\PassengerTypeQuantityType $passengerTypeQuantity = null, \SabreSoap\StructType\FareBasisCodes $fareBasisCodes = null, \SabreSoap\StructType\FareType $passengerFare = null, \SabreSoap\StructType\Endorsements $endorsements = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, \SabreSoap\StructType\FareInfos $fareInfos = null, $pricingSource = null, $privateFareType = null, $lastTicketDate = null, $previousExchangeDate = null, $reissueExchange = null)
    {
        $this
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setFareBasisCodes($fareBasisCodes)
            ->setPassengerFare($passengerFare)
            ->setEndorsements($endorsements)
            ->setTPA_Extensions($tPA_Extensions)
            ->setFareInfos($fareInfos)
            ->setPricingSource($pricingSource)
            ->setPrivateFareType($privateFareType)
            ->setLastTicketDate($lastTicketDate)
            ->setPreviousExchangeDate($previousExchangeDate)
            ->setReissueExchange($reissueExchange);
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \SabreSoap\StructType\PassengerTypeQuantityType|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param \SabreSoap\StructType\PassengerTypeQuantityType $passengerTypeQuantity
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setPassengerTypeQuantity(\SabreSoap\StructType\PassengerTypeQuantityType $passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get FareBasisCodes value
     * @return \SabreSoap\StructType\FareBasisCodes|null
     */
    public function getFareBasisCodes()
    {
        return $this->FareBasisCodes;
    }
    /**
     * Set FareBasisCodes value
     * @param \SabreSoap\StructType\FareBasisCodes $fareBasisCodes
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setFareBasisCodes(\SabreSoap\StructType\FareBasisCodes $fareBasisCodes = null)
    {
        $this->FareBasisCodes = $fareBasisCodes;
        return $this;
    }
    /**
     * Get PassengerFare value
     * @return \SabreSoap\StructType\FareType|null
     */
    public function getPassengerFare()
    {
        return $this->PassengerFare;
    }
    /**
     * Set PassengerFare value
     * @param \SabreSoap\StructType\FareType $passengerFare
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setPassengerFare(\SabreSoap\StructType\FareType $passengerFare = null)
    {
        $this->PassengerFare = $passengerFare;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \SabreSoap\StructType\Endorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \SabreSoap\StructType\Endorsements $endorsements
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setEndorsements(\SabreSoap\StructType\Endorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get FareInfos value
     * @return \SabreSoap\StructType\FareInfos|null
     */
    public function getFareInfos()
    {
        return $this->FareInfos;
    }
    /**
     * Set FareInfos value
     * @param \SabreSoap\StructType\FareInfos $fareInfos
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setFareInfos(\SabreSoap\StructType\FareInfos $fareInfos = null)
    {
        $this->FareInfos = $fareInfos;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setPricingSource($pricingSource = null)
    {
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get PrivateFareType value
     * @return string|null
     */
    public function getPrivateFareType()
    {
        return $this->PrivateFareType;
    }
    /**
     * Set PrivateFareType value
     * @param string $privateFareType
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setPrivateFareType($privateFareType = null)
    {
        $this->PrivateFareType = $privateFareType;
        return $this;
    }
    /**
     * Get LastTicketDate value
     * @return string|null
     */
    public function getLastTicketDate()
    {
        return $this->LastTicketDate;
    }
    /**
     * Set LastTicketDate value
     * @param string $lastTicketDate
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setLastTicketDate($lastTicketDate = null)
    {
        $this->LastTicketDate = $lastTicketDate;
        return $this;
    }
    /**
     * Get PreviousExchangeDate value
     * @return string|null
     */
    public function getPreviousExchangeDate()
    {
        return $this->PreviousExchangeDate;
    }
    /**
     * Set PreviousExchangeDate value
     * @param string $previousExchangeDate
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setPreviousExchangeDate($previousExchangeDate = null)
    {
        $this->PreviousExchangeDate = $previousExchangeDate;
        return $this;
    }
    /**
     * Get ReissueExchange value
     * @return int|null
     */
    public function getReissueExchange()
    {
        return $this->ReissueExchange;
    }
    /**
     * Set ReissueExchange value
     * @param int $reissueExchange
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public function setReissueExchange($reissueExchange = null)
    {
        $this->ReissueExchange = $reissueExchange;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\PTCFareBreakdownType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
