<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionsPerDatePairType StructType
 * @subpackage Structs
 */
class OptionsPerDatePairType extends AbstractStructBase
{
    /**
     * The Departure
     * Meta information extracted from the WSDL
     * - documentation: Departure date | IntelliSell Date type (required format: YYYY-MM-DD)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * - use: required
     * @var string
     */
    public $Departure;
    /**
     * The Min
     * Meta information extracted from the WSDL
     * - documentation: Minimum number of options per date/date pair
     * - use: required
     * @var int
     */
    public $Min;
    /**
     * The Max
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of options per date/date pair
     * - use: required
     * @var int
     */
    public $Max;
    /**
     * The Return
     * Meta information extracted from the WSDL
     * - documentation: Return date | IntelliSell Date type (required format: YYYY-MM-DD)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * - use: optional
     * @var string
     */
    public $Return;
    /**
     * Constructor method for OptionsPerDatePairType
     * @uses OptionsPerDatePairType::setDeparture()
     * @uses OptionsPerDatePairType::setMin()
     * @uses OptionsPerDatePairType::setMax()
     * @uses OptionsPerDatePairType::setReturn()
     * @param string $departure
     * @param int $min
     * @param int $max
     * @param string $return
     */
    public function __construct($departure = null, $min = null, $max = null, $return = null)
    {
        $this
            ->setDeparture($departure)
            ->setMin($min)
            ->setMax($max)
            ->setReturn($return);
    }
    /**
     * Get Departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->Departure;
    }
    /**
     * Set Departure value
     * @param string $departure
     * @return \SabreSoap\StructType\OptionsPerDatePairType
     */
    public function setDeparture($departure = null)
    {
        $this->Departure = $departure;
        return $this;
    }
    /**
     * Get Min value
     * @return int
     */
    public function getMin()
    {
        return $this->Min;
    }
    /**
     * Set Min value
     * @param int $min
     * @return \SabreSoap\StructType\OptionsPerDatePairType
     */
    public function setMin($min = null)
    {
        $this->Min = $min;
        return $this;
    }
    /**
     * Get Max value
     * @return int
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param int $max
     * @return \SabreSoap\StructType\OptionsPerDatePairType
     */
    public function setMax($max = null)
    {
        $this->Max = $max;
        return $this;
    }
    /**
     * Get Return value
     * @return string|null
     */
    public function getReturn()
    {
        return $this->Return;
    }
    /**
     * Set Return value
     * @param string $return
     * @return \SabreSoap\StructType\OptionsPerDatePairType
     */
    public function setReturn($return = null)
    {
        $this->Return = $return;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\OptionsPerDatePairType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
