<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OneWayProcessingMessageType StructType
 * @subpackage Structs
 */
class OneWayProcessingMessageType extends ProcessingMessageType
{
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: Departure date
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - documentation: Location identifying code. | Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - documentation: Location identifying code. | Used for Character Strings, length 1 to 8
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ArrivalAirport;
    /**
     * Constructor method for OneWayProcessingMessageType
     * @uses OneWayProcessingMessageType::setDepartureDate()
     * @uses OneWayProcessingMessageType::setDepartureAirport()
     * @uses OneWayProcessingMessageType::setArrivalAirport()
     * @param string $departureDate
     * @param string $departureAirport
     * @param string $arrivalAirport
     */
    public function __construct($departureDate = null, $departureAirport = null, $arrivalAirport = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport);
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \SabreSoap\StructType\OneWayProcessingMessageType
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return string|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param string $departureAirport
     * @return \SabreSoap\StructType\OneWayProcessingMessageType
     */
    public function setDepartureAirport($departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return string|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param string $arrivalAirport
     * @return \SabreSoap\StructType\OneWayProcessingMessageType
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\OneWayProcessingMessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
