<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OneWayItineraries StructType
 * Meta information extracted from the WSDL
 * - documentation: Successfull Low Fare priced itineraries in response to a Simplified One Way request.
 * @subpackage Structs
 */
class OneWayItineraries extends AbstractStructBase
{
    /**
     * The BrandedOneWayItineraries
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabreSoap\StructType\BrandedOneWayItineraries[]
     */
    public $BrandedOneWayItineraries;
    /**
     * The SimpleOneWayItineraries
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SimpleOneWayItineraries[]
     */
    public $SimpleOneWayItineraries;
    /**
     * Constructor method for OneWayItineraries
     * @uses OneWayItineraries::setBrandedOneWayItineraries()
     * @uses OneWayItineraries::setSimpleOneWayItineraries()
     * @param \SabreSoap\StructType\BrandedOneWayItineraries[] $brandedOneWayItineraries
     * @param \SabreSoap\StructType\SimpleOneWayItineraries[] $simpleOneWayItineraries
     */
    public function __construct(array $brandedOneWayItineraries = array(), array $simpleOneWayItineraries = array())
    {
        $this
            ->setBrandedOneWayItineraries($brandedOneWayItineraries)
            ->setSimpleOneWayItineraries($simpleOneWayItineraries);
    }
    /**
     * Get BrandedOneWayItineraries value
     * @return \SabreSoap\StructType\BrandedOneWayItineraries[]|null
     */
    public function getBrandedOneWayItineraries()
    {
        return $this->BrandedOneWayItineraries;
    }
    /**
     * Set BrandedOneWayItineraries value
     * @param \SabreSoap\StructType\BrandedOneWayItineraries[] $brandedOneWayItineraries
     * @return \SabreSoap\StructType\OneWayItineraries
     */
    public function setBrandedOneWayItineraries(array $brandedOneWayItineraries = array())
    {
        $this->BrandedOneWayItineraries = $brandedOneWayItineraries;
        return $this;
    }
    /**
     * Add item to BrandedOneWayItineraries value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\BrandedOneWayItineraries $item
     * @return \SabreSoap\StructType\OneWayItineraries
     */
    public function addToBrandedOneWayItineraries(\SabreSoap\StructType\BrandedOneWayItineraries $item)
    {
        $this->BrandedOneWayItineraries[] = $item;
        return $this;
    }
    /**
     * Get SimpleOneWayItineraries value
     * @return \SabreSoap\StructType\SimpleOneWayItineraries[]|null
     */
    public function getSimpleOneWayItineraries()
    {
        return $this->SimpleOneWayItineraries;
    }
    /**
     * Set SimpleOneWayItineraries value
     * @param \SabreSoap\StructType\SimpleOneWayItineraries[] $simpleOneWayItineraries
     * @return \SabreSoap\StructType\OneWayItineraries
     */
    public function setSimpleOneWayItineraries(array $simpleOneWayItineraries = array())
    {
        $this->SimpleOneWayItineraries = $simpleOneWayItineraries;
        return $this;
    }
    /**
     * Add item to SimpleOneWayItineraries value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\SimpleOneWayItineraries $item
     * @return \SabreSoap\StructType\OneWayItineraries
     */
    public function addToSimpleOneWayItineraries(\SabreSoap\StructType\SimpleOneWayItineraries $item)
    {
        $this->SimpleOneWayItineraries[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\OneWayItineraries
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
