<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultipleTravelerGroups StructType
 * Meta information extracted from the WSDL
 * - documentation: This element governs how flights are returned when multiple passenger groups are requested.
 * @subpackage Structs
 */
class MultipleTravelerGroups extends AbstractStructBase
{
    /**
     * The ItinerariesPerGroup
     * Meta information extracted from the WSDL
     * - documentation: Indicates desired number of itineraries to be returned in each passenger group at beggining of response. | Used for Numeric values, from 1 to 99 inclusive
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * @var int
     */
    public $ItinerariesPerGroup;
    /**
     * The GroupNumber
     * @var int
     */
    public $GroupNumber;
    /**
     * The PrimaryGroup
     * @var bool
     */
    public $PrimaryGroup;
    /**
     * Constructor method for MultipleTravelerGroups
     * @uses MultipleTravelerGroups::setItinerariesPerGroup()
     * @uses MultipleTravelerGroups::setGroupNumber()
     * @uses MultipleTravelerGroups::setPrimaryGroup()
     * @param int $itinerariesPerGroup
     * @param int $groupNumber
     * @param bool $primaryGroup
     */
    public function __construct($itinerariesPerGroup = null, $groupNumber = null, $primaryGroup = null)
    {
        $this
            ->setItinerariesPerGroup($itinerariesPerGroup)
            ->setGroupNumber($groupNumber)
            ->setPrimaryGroup($primaryGroup);
    }
    /**
     * Get ItinerariesPerGroup value
     * @return int|null
     */
    public function getItinerariesPerGroup()
    {
        return $this->ItinerariesPerGroup;
    }
    /**
     * Set ItinerariesPerGroup value
     * @param int $itinerariesPerGroup
     * @return \SabreSoap\StructType\MultipleTravelerGroups
     */
    public function setItinerariesPerGroup($itinerariesPerGroup = null)
    {
        $this->ItinerariesPerGroup = $itinerariesPerGroup;
        return $this;
    }
    /**
     * Get GroupNumber value
     * @return int|null
     */
    public function getGroupNumber()
    {
        return $this->GroupNumber;
    }
    /**
     * Set GroupNumber value
     * @param int $groupNumber
     * @return \SabreSoap\StructType\MultipleTravelerGroups
     */
    public function setGroupNumber($groupNumber = null)
    {
        $this->GroupNumber = $groupNumber;
        return $this;
    }
    /**
     * Get PrimaryGroup value
     * @return bool|null
     */
    public function getPrimaryGroup()
    {
        return $this->PrimaryGroup;
    }
    /**
     * Set PrimaryGroup value
     * @param bool $primaryGroup
     * @return \SabreSoap\StructType\MultipleTravelerGroups
     */
    public function setPrimaryGroup($primaryGroup = null)
    {
        $this->PrimaryGroup = $primaryGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\MultipleTravelerGroups
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
