<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageHeader StructType
 * @subpackage Structs
 */
class MessageHeader extends AbstractStructBase
{
    /**
     * The From
     * Meta information extracted from the WSDL
     * - ref: tns:From
     * @var \SabreSoap\StructType\From
     */
    public $From;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - ref: tns:To
     * @var \SabreSoap\StructType\To
     */
    public $To;
    /**
     * The CPAId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:CPAId
     * @var string
     */
    public $CPAId;
    /**
     * The ConversationId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:ConversationId
     * @var string
     */
    public $ConversationId;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - ref: tns:Service
     * @var \SabreSoap\StructType\Service
     */
    public $Service;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:Action
     * @var string
     */
    public $Action;
    /**
     * The MessageData
     * Meta information extracted from the WSDL
     * - ref: tns:MessageData
     * @var \SabreSoap\StructType\MessageData
     */
    public $MessageData;
    /**
     * The DuplicateElimination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:DuplicateElimination
     * @var mixed
     */
    public $DuplicateElimination;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \SabreSoap\StructType\Description[]
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for MessageHeader
     * @uses MessageHeader::setFrom()
     * @uses MessageHeader::setTo()
     * @uses MessageHeader::setCPAId()
     * @uses MessageHeader::setConversationId()
     * @uses MessageHeader::setService()
     * @uses MessageHeader::setAction()
     * @uses MessageHeader::setMessageData()
     * @uses MessageHeader::setDuplicateElimination()
     * @uses MessageHeader::setDescription()
     * @uses MessageHeader::setAny()
     * @uses MessageHeader::setId()
     * @uses MessageHeader::setVersion()
     * @param \SabreSoap\StructType\From $from
     * @param \SabreSoap\StructType\To $to
     * @param string $cPAId
     * @param string $conversationId
     * @param \SabreSoap\StructType\Service $service
     * @param string $action
     * @param \SabreSoap\StructType\MessageData $messageData
     * @param mixed $duplicateElimination
     * @param \SabreSoap\StructType\Description[] $description
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct(\SabreSoap\StructType\From $from = null, \SabreSoap\StructType\To $to = null, $cPAId = null, $conversationId = null, \SabreSoap\StructType\Service $service = null, $action = null, \SabreSoap\StructType\MessageData $messageData = null, $duplicateElimination = null, array $description = array(), \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setCPAId($cPAId)
            ->setConversationId($conversationId)
            ->setService($service)
            ->setAction($action)
            ->setMessageData($messageData)
            ->setDuplicateElimination($duplicateElimination)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get From value
     * @return \SabreSoap\StructType\From|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param \SabreSoap\StructType\From $from
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setFrom(\SabreSoap\StructType\From $from = null)
    {
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return \SabreSoap\StructType\To|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param \SabreSoap\StructType\To $to
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setTo(\SabreSoap\StructType\To $to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get CPAId value
     * @return string|null
     */
    public function getCPAId()
    {
        return $this->CPAId;
    }
    /**
     * Set CPAId value
     * @param string $cPAId
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setCPAId($cPAId = null)
    {
        $this->CPAId = $cPAId;
        return $this;
    }
    /**
     * Get ConversationId value
     * @return string|null
     */
    public function getConversationId()
    {
        return $this->ConversationId;
    }
    /**
     * Set ConversationId value
     * @param string $conversationId
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setConversationId($conversationId = null)
    {
        $this->ConversationId = $conversationId;
        return $this;
    }
    /**
     * Get Service value
     * @return \SabreSoap\StructType\Service|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \SabreSoap\StructType\Service $service
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setService(\SabreSoap\StructType\Service $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setAction($action = null)
    {
        $this->Action = $action;
        return $this;
    }
    /**
     * Get MessageData value
     * @return \SabreSoap\StructType\MessageData|null
     */
    public function getMessageData()
    {
        return $this->MessageData;
    }
    /**
     * Set MessageData value
     * @param \SabreSoap\StructType\MessageData $messageData
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setMessageData(\SabreSoap\StructType\MessageData $messageData = null)
    {
        $this->MessageData = $messageData;
        return $this;
    }
    /**
     * Get DuplicateElimination value
     * @return mixed|null
     */
    public function getDuplicateElimination()
    {
        return $this->DuplicateElimination;
    }
    /**
     * Set DuplicateElimination value
     * @param mixed $duplicateElimination
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setDuplicateElimination($duplicateElimination = null)
    {
        $this->DuplicateElimination = $duplicateElimination;
        return $this;
    }
    /**
     * Get Description value
     * @return \SabreSoap\StructType\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \SabreSoap\StructType\Description[] $description
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Description $item
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function addToDescription(\SabreSoap\StructType\Description $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabreSoap\StructType\MessageHeader
     */
    public function setVersion($version = null)
    {
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\MessageHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
