<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LongConnectTime StructType
 * Meta information extracted from the WSDL
 * - documentation: Change minimum and maximum connect time per connection in long connection schedules if Long Connect Time logic is enabled. Specified values should be less than 1440 minutes (24 hours).
 * @subpackage Structs
 */
class LongConnectTime extends AbstractStructBase
{
    /**
     * The Min
     * @var int
     */
    public $Min;
    /**
     * The Max
     * @var int
     */
    public $Max;
    /**
     * The Enable
     * @var bool
     */
    public $Enable;
    /**
     * Constructor method for LongConnectTime
     * @uses LongConnectTime::setMin()
     * @uses LongConnectTime::setMax()
     * @uses LongConnectTime::setEnable()
     * @param int $min
     * @param int $max
     * @param bool $enable
     */
    public function __construct($min = null, $max = null, $enable = null)
    {
        $this
            ->setMin($min)
            ->setMax($max)
            ->setEnable($enable);
    }
    /**
     * Get Min value
     * @return int|null
     */
    public function getMin()
    {
        return $this->Min;
    }
    /**
     * Set Min value
     * @param int $min
     * @return \SabreSoap\StructType\LongConnectTime
     */
    public function setMin($min = null)
    {
        $this->Min = $min;
        return $this;
    }
    /**
     * Get Max value
     * @return int|null
     */
    public function getMax()
    {
        return $this->Max;
    }
    /**
     * Set Max value
     * @param int $max
     * @return \SabreSoap\StructType\LongConnectTime
     */
    public function setMax($max = null)
    {
        $this->Max = $max;
        return $this;
    }
    /**
     * Get Enable value
     * @return bool|null
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param bool $enable
     * @return \SabreSoap\StructType\LongConnectTime
     */
    public function setEnable($enable = null)
    {
        $this->Enable = $enable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\LongConnectTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
