<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Leg StructType
 * Meta information extracted from the WSDL
 * - documentation: Leg Information | Optional list of departure dates for each leg
 * @subpackage Structs
 */
class Leg extends SummaryPriceInformation
{
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: Departure date
     * - use: required
     * @var string
     */
    public $DepartureDate;
    /**
     * The Segment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Segment[]
     */
    public $Segment;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The BrandID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrandID;
    /**
     * The BrandDescription
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrandDescription;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramName;
    /**
     * The ProgramID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramID;
    /**
     * The ProgramCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramCode;
    /**
     * The ProgramSystemCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProgramSystemCode;
    /**
     * The FareStatus
     * Meta information extracted from the WSDL
     * - documentation: Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable", "N" - unknown status.
     * - use: optional
     * @var string
     */
    public $FareStatus;
    /**
     * Constructor method for Leg
     * @uses Leg::setDepartureDate()
     * @uses Leg::setSegment()
     * @uses Leg::setNumber()
     * @uses Leg::setBrandID()
     * @uses Leg::setBrandDescription()
     * @uses Leg::setProgramName()
     * @uses Leg::setProgramID()
     * @uses Leg::setProgramCode()
     * @uses Leg::setProgramSystemCode()
     * @uses Leg::setFareStatus()
     * @param string $departureDate
     * @param \SabreSoap\StructType\Segment[] $segment
     * @param string $number
     * @param string $brandID
     * @param string $brandDescription
     * @param string $programName
     * @param string $programID
     * @param string $programCode
     * @param string $programSystemCode
     * @param string $fareStatus
     */
    public function __construct($departureDate = null, array $segment = array(), $number = null, $brandID = null, $brandDescription = null, $programName = null, $programID = null, $programCode = null, $programSystemCode = null, $fareStatus = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setSegment($segment)
            ->setNumber($number)
            ->setBrandID($brandID)
            ->setBrandDescription($brandDescription)
            ->setProgramName($programName)
            ->setProgramID($programID)
            ->setProgramCode($programCode)
            ->setProgramSystemCode($programSystemCode)
            ->setFareStatus($fareStatus);
    }
    /**
     * Get DepartureDate value
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \SabreSoap\StructType\Leg
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Segment value
     * @return \SabreSoap\StructType\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \SabreSoap\StructType\Segment[] $segment
     * @return \SabreSoap\StructType\Leg
     */
    public function setSegment(array $segment = array())
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Segment $item
     * @return \SabreSoap\StructType\Leg
     */
    public function addToSegment(\SabreSoap\StructType\Segment $item)
    {
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \SabreSoap\StructType\Leg
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \SabreSoap\StructType\Leg
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get BrandDescription value
     * @return string|null
     */
    public function getBrandDescription()
    {
        return $this->BrandDescription;
    }
    /**
     * Set BrandDescription value
     * @param string $brandDescription
     * @return \SabreSoap\StructType\Leg
     */
    public function setBrandDescription($brandDescription = null)
    {
        $this->BrandDescription = $brandDescription;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \SabreSoap\StructType\Leg
     */
    public function setProgramName($programName = null)
    {
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \SabreSoap\StructType\Leg
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \SabreSoap\StructType\Leg
     */
    public function setProgramCode($programCode = null)
    {
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get ProgramSystemCode value
     * @return string|null
     */
    public function getProgramSystemCode()
    {
        return $this->ProgramSystemCode;
    }
    /**
     * Set ProgramSystemCode value
     * @param string $programSystemCode
     * @return \SabreSoap\StructType\Leg
     */
    public function setProgramSystemCode($programSystemCode = null)
    {
        $this->ProgramSystemCode = $programSystemCode;
        return $this;
    }
    /**
     * Get FareStatus value
     * @return string|null
     */
    public function getFareStatus()
    {
        return $this->FareStatus;
    }
    /**
     * Set FareStatus value
     * @param string $fareStatus
     * @return \SabreSoap\StructType\Leg
     */
    public function setFareStatus($fareStatus = null)
    {
        $this->FareStatus = $fareStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Leg
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
