<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponent StructType
 * Meta information extracted from the WSDL
 * - documentation: Subtotal pricing summary for Fare Component.
 * @subpackage Structs
 */
class FareComponent extends SummaryPriceInformation
{
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The ProgramDescription
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate program description
     * - use: optional
     * @var string
     */
    public $ProgramDescription;
    /**
     * The ProgramSystemCode
     * @var string
     */
    public $ProgramSystemCode;
    /**
     * The BrandID
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate brand code
     * - use: optional
     * @var string
     */
    public $BrandID;
    /**
     * The BrandName
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate brand name
     * - use: optional
     * @var string
     */
    public $BrandName;
    /**
     * Constructor method for FareComponent
     * @uses FareComponent::setProgramID()
     * @uses FareComponent::setProgramDescription()
     * @uses FareComponent::setProgramSystemCode()
     * @uses FareComponent::setBrandID()
     * @uses FareComponent::setBrandName()
     * @param string $programID
     * @param string $programDescription
     * @param string $programSystemCode
     * @param string $brandID
     * @param string $brandName
     */
    public function __construct($programID = null, $programDescription = null, $programSystemCode = null, $brandID = null, $brandName = null)
    {
        $this
            ->setProgramID($programID)
            ->setProgramDescription($programDescription)
            ->setProgramSystemCode($programSystemCode)
            ->setBrandID($brandID)
            ->setBrandName($brandName);
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \SabreSoap\StructType\FareComponent
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get ProgramDescription value
     * @return string|null
     */
    public function getProgramDescription()
    {
        return $this->ProgramDescription;
    }
    /**
     * Set ProgramDescription value
     * @param string $programDescription
     * @return \SabreSoap\StructType\FareComponent
     */
    public function setProgramDescription($programDescription = null)
    {
        $this->ProgramDescription = $programDescription;
        return $this;
    }
    /**
     * Get ProgramSystemCode value
     * @return string|null
     */
    public function getProgramSystemCode()
    {
        return $this->ProgramSystemCode;
    }
    /**
     * Set ProgramSystemCode value
     * @param string $programSystemCode
     * @return \SabreSoap\StructType\FareComponent
     */
    public function setProgramSystemCode($programSystemCode = null)
    {
        $this->ProgramSystemCode = $programSystemCode;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \SabreSoap\StructType\FareComponent
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \SabreSoap\StructType\FareComponent
     */
    public function setBrandName($brandName = null)
    {
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\FareComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
