<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeType StructType
 * @subpackage Structs
 */
class ExchangeType extends AbstractStructBase
{
    /**
     * The OriginalTktIssueDateTime
     * Meta information extracted from the WSDL
     * - documentation: Original ticket issue date and time | IntelliSell DateTime type with optional time component (required format: YYYY-MM-DD or YYYY-MM-DDTHH:MM:SS)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}(T[0-9]{2}:[0-9]{2}:[0-9]{2})?
     * - type: ISellDateOptTimeType
     * - use: required
     * @var string
     */
    public $OriginalTktIssueDateTime;
    /**
     * The Fare
     * @var \SabreSoap\StructType\ExchangeFareType
     */
    public $Fare;
    /**
     * The POS
     * @var \SabreSoap\StructType\ExchangePOSType
     */
    public $POS;
    /**
     * The OriginDestinationInformation
     * @var \SabreSoap\StructType\ExchangeOriginDestinationInformationType
     */
    public $OriginDestinationInformation;
    /**
     * The Arunk
     * @var \SabreSoap\StructType\ArunkType
     */
    public $Arunk;
    /**
     * The TravelPreferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ExchangeAirSearchPrefsType
     */
    public $TravelPreferences;
    /**
     * The TravelerInfoSummary
     * @var \SabreSoap\StructType\TravelerInfoSummaryType
     */
    public $TravelerInfoSummary;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ExchangeTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ExchangedTktIssueDateTime
     * Meta information extracted from the WSDL
     * - documentation: Exchanged ticket issue date and time | IntelliSell DateTime type with optional time component (required format: YYYY-MM-DD or YYYY-MM-DDTHH:MM:SS)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}(T[0-9]{2}:[0-9]{2}:[0-9]{2})?
     * - type: ISellDateOptTimeType
     * - use: optional
     * @var string
     */
    public $ExchangedTktIssueDateTime;
    /**
     * The PreviousExchangeDateTime
     * Meta information extracted from the WSDL
     * - documentation: Previous exchange date and time | IntelliSell DateTime type with optional time component (required format: YYYY-MM-DD or YYYY-MM-DDTHH:MM:SS)
     * - base: xs:string
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}(T[0-9]{2}:[0-9]{2}:[0-9]{2})?
     * - type: ISellDateOptTimeType
     * - use: optional
     * @var string
     */
    public $PreviousExchangeDateTime;
    /**
     * The NumberOfTaxBoxes
     * Meta information extracted from the WSDL
     * - documentation: Number of tax boxes
     * - type: xs:short
     * - use: optional
     * @var int
     */
    public $NumberOfTaxBoxes;
    /**
     * The BypassAdvancePurchaseOption
     * Meta information extracted from the WSDL
     * - documentation: Bypass Advance Purchase Option | Used for Characters, length 1
     * - base: xs:string
     * - length: 1
     * - type: CharacterType
     * - use: optional
     * @var string
     */
    public $BypassAdvancePurchaseOption;
    /**
     * Constructor method for ExchangeType
     * @uses ExchangeType::setOriginalTktIssueDateTime()
     * @uses ExchangeType::setFare()
     * @uses ExchangeType::setPOS()
     * @uses ExchangeType::setOriginDestinationInformation()
     * @uses ExchangeType::setArunk()
     * @uses ExchangeType::setTravelPreferences()
     * @uses ExchangeType::setTravelerInfoSummary()
     * @uses ExchangeType::setTPA_Extensions()
     * @uses ExchangeType::setExchangedTktIssueDateTime()
     * @uses ExchangeType::setPreviousExchangeDateTime()
     * @uses ExchangeType::setNumberOfTaxBoxes()
     * @uses ExchangeType::setBypassAdvancePurchaseOption()
     * @param string $originalTktIssueDateTime
     * @param \SabreSoap\StructType\ExchangeFareType $fare
     * @param \SabreSoap\StructType\ExchangePOSType $pOS
     * @param \SabreSoap\StructType\ExchangeOriginDestinationInformationType $originDestinationInformation
     * @param \SabreSoap\StructType\ArunkType $arunk
     * @param \SabreSoap\StructType\ExchangeAirSearchPrefsType $travelPreferences
     * @param \SabreSoap\StructType\TravelerInfoSummaryType $travelerInfoSummary
     * @param \SabreSoap\StructType\ExchangeTPA_ExtensionsType $tPA_Extensions
     * @param string $exchangedTktIssueDateTime
     * @param string $previousExchangeDateTime
     * @param int $numberOfTaxBoxes
     * @param string $bypassAdvancePurchaseOption
     */
    public function __construct($originalTktIssueDateTime = null, \SabreSoap\StructType\ExchangeFareType $fare = null, \SabreSoap\StructType\ExchangePOSType $pOS = null, \SabreSoap\StructType\ExchangeOriginDestinationInformationType $originDestinationInformation = null, \SabreSoap\StructType\ArunkType $arunk = null, \SabreSoap\StructType\ExchangeAirSearchPrefsType $travelPreferences = null, \SabreSoap\StructType\TravelerInfoSummaryType $travelerInfoSummary = null, \SabreSoap\StructType\ExchangeTPA_ExtensionsType $tPA_Extensions = null, $exchangedTktIssueDateTime = null, $previousExchangeDateTime = null, $numberOfTaxBoxes = null, $bypassAdvancePurchaseOption = null)
    {
        $this
            ->setOriginalTktIssueDateTime($originalTktIssueDateTime)
            ->setFare($fare)
            ->setPOS($pOS)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setArunk($arunk)
            ->setTravelPreferences($travelPreferences)
            ->setTravelerInfoSummary($travelerInfoSummary)
            ->setTPA_Extensions($tPA_Extensions)
            ->setExchangedTktIssueDateTime($exchangedTktIssueDateTime)
            ->setPreviousExchangeDateTime($previousExchangeDateTime)
            ->setNumberOfTaxBoxes($numberOfTaxBoxes)
            ->setBypassAdvancePurchaseOption($bypassAdvancePurchaseOption);
    }
    /**
     * Get OriginalTktIssueDateTime value
     * @return string
     */
    public function getOriginalTktIssueDateTime()
    {
        return $this->OriginalTktIssueDateTime;
    }
    /**
     * Set OriginalTktIssueDateTime value
     * @param string $originalTktIssueDateTime
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setOriginalTktIssueDateTime($originalTktIssueDateTime = null)
    {
        $this->OriginalTktIssueDateTime = $originalTktIssueDateTime;
        return $this;
    }
    /**
     * Get Fare value
     * @return \SabreSoap\StructType\ExchangeFareType|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \SabreSoap\StructType\ExchangeFareType $fare
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setFare(\SabreSoap\StructType\ExchangeFareType $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get POS value
     * @return \SabreSoap\StructType\ExchangePOSType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \SabreSoap\StructType\ExchangePOSType $pOS
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setPOS(\SabreSoap\StructType\ExchangePOSType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \SabreSoap\StructType\ExchangeOriginDestinationInformationType|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @param \SabreSoap\StructType\ExchangeOriginDestinationInformationType $originDestinationInformation
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setOriginDestinationInformation(\SabreSoap\StructType\ExchangeOriginDestinationInformationType $originDestinationInformation = null)
    {
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Get Arunk value
     * @return \SabreSoap\StructType\ArunkType|null
     */
    public function getArunk()
    {
        return $this->Arunk;
    }
    /**
     * Set Arunk value
     * @param \SabreSoap\StructType\ArunkType $arunk
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setArunk(\SabreSoap\StructType\ArunkType $arunk = null)
    {
        $this->Arunk = $arunk;
        return $this;
    }
    /**
     * Get TravelPreferences value
     * @return \SabreSoap\StructType\ExchangeAirSearchPrefsType|null
     */
    public function getTravelPreferences()
    {
        return $this->TravelPreferences;
    }
    /**
     * Set TravelPreferences value
     * @param \SabreSoap\StructType\ExchangeAirSearchPrefsType $travelPreferences
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setTravelPreferences(\SabreSoap\StructType\ExchangeAirSearchPrefsType $travelPreferences = null)
    {
        $this->TravelPreferences = $travelPreferences;
        return $this;
    }
    /**
     * Get TravelerInfoSummary value
     * @return \SabreSoap\StructType\TravelerInfoSummaryType|null
     */
    public function getTravelerInfoSummary()
    {
        return $this->TravelerInfoSummary;
    }
    /**
     * Set TravelerInfoSummary value
     * @param \SabreSoap\StructType\TravelerInfoSummaryType $travelerInfoSummary
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setTravelerInfoSummary(\SabreSoap\StructType\TravelerInfoSummaryType $travelerInfoSummary = null)
    {
        $this->TravelerInfoSummary = $travelerInfoSummary;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\ExchangeTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\ExchangeTPA_ExtensionsType $tPA_Extensions
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\ExchangeTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ExchangedTktIssueDateTime value
     * @return string|null
     */
    public function getExchangedTktIssueDateTime()
    {
        return $this->ExchangedTktIssueDateTime;
    }
    /**
     * Set ExchangedTktIssueDateTime value
     * @param string $exchangedTktIssueDateTime
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setExchangedTktIssueDateTime($exchangedTktIssueDateTime = null)
    {
        $this->ExchangedTktIssueDateTime = $exchangedTktIssueDateTime;
        return $this;
    }
    /**
     * Get PreviousExchangeDateTime value
     * @return string|null
     */
    public function getPreviousExchangeDateTime()
    {
        return $this->PreviousExchangeDateTime;
    }
    /**
     * Set PreviousExchangeDateTime value
     * @param string $previousExchangeDateTime
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setPreviousExchangeDateTime($previousExchangeDateTime = null)
    {
        $this->PreviousExchangeDateTime = $previousExchangeDateTime;
        return $this;
    }
    /**
     * Get NumberOfTaxBoxes value
     * @return int|null
     */
    public function getNumberOfTaxBoxes()
    {
        return $this->NumberOfTaxBoxes;
    }
    /**
     * Set NumberOfTaxBoxes value
     * @param int $numberOfTaxBoxes
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setNumberOfTaxBoxes($numberOfTaxBoxes = null)
    {
        $this->NumberOfTaxBoxes = $numberOfTaxBoxes;
        return $this;
    }
    /**
     * Get BypassAdvancePurchaseOption value
     * @return string|null
     */
    public function getBypassAdvancePurchaseOption()
    {
        return $this->BypassAdvancePurchaseOption;
    }
    /**
     * Set BypassAdvancePurchaseOption value
     * @param string $bypassAdvancePurchaseOption
     * @return \SabreSoap\StructType\ExchangeType
     */
    public function setBypassAdvancePurchaseOption($bypassAdvancePurchaseOption = null)
    {
        $this->BypassAdvancePurchaseOption = $bypassAdvancePurchaseOption;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ExchangeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
