<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeSourceType StructType
 * @subpackage Structs
 */
class ExchangeSourceType extends AbstractStructBase
{
    /**
     * The AgentCity
     * Meta information extracted from the WSDL
     * - documentation: Agent city | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: required
     * @var string
     */
    public $AgentCity;
    /**
     * The MainTravelAgencyPCC
     * Meta information extracted from the WSDL
     * - documentation: Main travel agency PCC | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: required
     * @var string
     */
    public $MainTravelAgencyPCC;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: Carrier
     * - base: xs:string
     * - pattern: [0-9A-Z]{2,3}
     * - type: CarrierCode
     * - use: required
     * @var string
     */
    public $Carrier;
    /**
     * The BookingChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\SourceBookingChannelType
     */
    public $BookingChannel;
    /**
     * The AgentSine
     * Meta information extracted from the WSDL
     * - documentation: Identifies the party within the requesting entity. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $AgentSine;
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The ISOCountry
     * Meta information extracted from the WSDL
     * - documentation: The country code of the requesting party. | 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - type: ISO3166
     * - use: optional
     * @var string
     */
    public $ISOCountry;
    /**
     * The ISOCurrency
     * Meta information extracted from the WSDL
     * - documentation: The currency code in which the reservation will be ticketed. | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: optional
     * @var string
     */
    public $ISOCurrency;
    /**
     * The AgentDutyCode
     * Meta information extracted from the WSDL
     * - documentation: An authority code assigned to a requestor. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The AirlineVendorID
     * Meta information extracted from the WSDL
     * - documentation: The IATA assigned airline code. | Used for an Upper Alpha String and Numeric, length 2 to 3.
     * - base: xs:string
     * - pattern: [A-Z0-9]{2,3}
     * - type: UpperCaseAlphaNumericLength2to3
     * - use: optional
     * @var string
     */
    public $AirlineVendorID;
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - documentation: The IATA assigned airport code. | Used for an Upper Alpha String and Numeric, length 3 to 5.
     * - base: xs:string
     * - pattern: [A-Z0-9]{3,5}
     * - type: UpperCaseAlphaNumericLength3to5
     * - use: optional
     * @var string
     */
    public $AirportCode;
    /**
     * The FirstDepartPoint
     * Meta information extracted from the WSDL
     * - documentation: The point of first departure in a trip. | Used for Strings, length exactly 3
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - type: StringLength3
     * - use: optional
     * @var string
     */
    public $FirstDepartPoint;
    /**
     * The ERSP_UserID
     * Meta information extracted from the WSDL
     * - documentation: Electronic Reservation Service Provider (ERSP) assigned identifier used to identify the individual using the ERSP system. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $ERSP_UserID;
    /**
     * The PersonalCityCode
     * @var string
     */
    public $PersonalCityCode;
    /**
     * The AccountingCode
     * @var string
     */
    public $AccountingCode;
    /**
     * The OfficeCode
     * @var string
     */
    public $OfficeCode;
    /**
     * The DefaultTicketingCarrier
     * @var string
     */
    public $DefaultTicketingCarrier;
    /**
     * The HostCarrier
     * Meta information extracted from the WSDL
     * - documentation: PCC Host Carrier
     * - base: xs:string
     * - pattern: [0-9A-Z]{2,3}
     * - type: CarrierCode
     * - use: optional
     * @var string
     */
    public $HostCarrier;
    /**
     * The ETicketCapable
     * Meta information extracted from the WSDL
     * - documentation: Agency is Eticket capable
     * - default: false
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $ETicketCapable;
    /**
     * The CoHostID
     * Meta information extracted from the WSDL
     * - documentation: CoHostID
     * - type: xs:short
     * - use: optional
     * @var int
     */
    public $CoHostID;
    /**
     * Constructor method for ExchangeSourceType
     * @uses ExchangeSourceType::setAgentCity()
     * @uses ExchangeSourceType::setMainTravelAgencyPCC()
     * @uses ExchangeSourceType::setCarrier()
     * @uses ExchangeSourceType::setBookingChannel()
     * @uses ExchangeSourceType::setAgentSine()
     * @uses ExchangeSourceType::setPseudoCityCode()
     * @uses ExchangeSourceType::setISOCountry()
     * @uses ExchangeSourceType::setISOCurrency()
     * @uses ExchangeSourceType::setAgentDutyCode()
     * @uses ExchangeSourceType::setAirlineVendorID()
     * @uses ExchangeSourceType::setAirportCode()
     * @uses ExchangeSourceType::setFirstDepartPoint()
     * @uses ExchangeSourceType::setERSP_UserID()
     * @uses ExchangeSourceType::setPersonalCityCode()
     * @uses ExchangeSourceType::setAccountingCode()
     * @uses ExchangeSourceType::setOfficeCode()
     * @uses ExchangeSourceType::setDefaultTicketingCarrier()
     * @uses ExchangeSourceType::setHostCarrier()
     * @uses ExchangeSourceType::setETicketCapable()
     * @uses ExchangeSourceType::setCoHostID()
     * @param string $agentCity
     * @param string $mainTravelAgencyPCC
     * @param string $carrier
     * @param \SabreSoap\StructType\SourceBookingChannelType $bookingChannel
     * @param string $agentSine
     * @param string $pseudoCityCode
     * @param string $iSOCountry
     * @param string $iSOCurrency
     * @param string $agentDutyCode
     * @param string $airlineVendorID
     * @param string $airportCode
     * @param string $firstDepartPoint
     * @param string $eRSP_UserID
     * @param string $personalCityCode
     * @param string $accountingCode
     * @param string $officeCode
     * @param string $defaultTicketingCarrier
     * @param string $hostCarrier
     * @param bool $eTicketCapable
     * @param int $coHostID
     */
    public function __construct($agentCity = null, $mainTravelAgencyPCC = null, $carrier = null, \SabreSoap\StructType\SourceBookingChannelType $bookingChannel = null, $agentSine = null, $pseudoCityCode = null, $iSOCountry = null, $iSOCurrency = null, $agentDutyCode = null, $airlineVendorID = null, $airportCode = null, $firstDepartPoint = null, $eRSP_UserID = null, $personalCityCode = null, $accountingCode = null, $officeCode = null, $defaultTicketingCarrier = null, $hostCarrier = null, $eTicketCapable = false, $coHostID = null)
    {
        $this
            ->setAgentCity($agentCity)
            ->setMainTravelAgencyPCC($mainTravelAgencyPCC)
            ->setCarrier($carrier)
            ->setBookingChannel($bookingChannel)
            ->setAgentSine($agentSine)
            ->setPseudoCityCode($pseudoCityCode)
            ->setISOCountry($iSOCountry)
            ->setISOCurrency($iSOCurrency)
            ->setAgentDutyCode($agentDutyCode)
            ->setAirlineVendorID($airlineVendorID)
            ->setAirportCode($airportCode)
            ->setFirstDepartPoint($firstDepartPoint)
            ->setERSP_UserID($eRSP_UserID)
            ->setPersonalCityCode($personalCityCode)
            ->setAccountingCode($accountingCode)
            ->setOfficeCode($officeCode)
            ->setDefaultTicketingCarrier($defaultTicketingCarrier)
            ->setHostCarrier($hostCarrier)
            ->setETicketCapable($eTicketCapable)
            ->setCoHostID($coHostID);
    }
    /**
     * Get AgentCity value
     * @return string
     */
    public function getAgentCity()
    {
        return $this->AgentCity;
    }
    /**
     * Set AgentCity value
     * @param string $agentCity
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setAgentCity($agentCity = null)
    {
        $this->AgentCity = $agentCity;
        return $this;
    }
    /**
     * Get MainTravelAgencyPCC value
     * @return string
     */
    public function getMainTravelAgencyPCC()
    {
        return $this->MainTravelAgencyPCC;
    }
    /**
     * Set MainTravelAgencyPCC value
     * @param string $mainTravelAgencyPCC
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setMainTravelAgencyPCC($mainTravelAgencyPCC = null)
    {
        $this->MainTravelAgencyPCC = $mainTravelAgencyPCC;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setCarrier($carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return \SabreSoap\StructType\SourceBookingChannelType|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \SabreSoap\StructType\SourceBookingChannelType $bookingChannel
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setBookingChannel(\SabreSoap\StructType\SourceBookingChannelType $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setAgentSine($agentSine = null)
    {
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setISOCountry($iSOCountry = null)
    {
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get ISOCurrency value
     * @return string|null
     */
    public function getISOCurrency()
    {
        return $this->ISOCurrency;
    }
    /**
     * Set ISOCurrency value
     * @param string $iSOCurrency
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setISOCurrency($iSOCurrency = null)
    {
        $this->ISOCurrency = $iSOCurrency;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get AirlineVendorID value
     * @return string|null
     */
    public function getAirlineVendorID()
    {
        return $this->AirlineVendorID;
    }
    /**
     * Set AirlineVendorID value
     * @param string $airlineVendorID
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setAirlineVendorID($airlineVendorID = null)
    {
        $this->AirlineVendorID = $airlineVendorID;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setAirportCode($airportCode = null)
    {
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get FirstDepartPoint value
     * @return string|null
     */
    public function getFirstDepartPoint()
    {
        return $this->FirstDepartPoint;
    }
    /**
     * Set FirstDepartPoint value
     * @param string $firstDepartPoint
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setFirstDepartPoint($firstDepartPoint = null)
    {
        $this->FirstDepartPoint = $firstDepartPoint;
        return $this;
    }
    /**
     * Get ERSP_UserID value
     * @return string|null
     */
    public function getERSP_UserID()
    {
        return $this->ERSP_UserID;
    }
    /**
     * Set ERSP_UserID value
     * @param string $eRSP_UserID
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setERSP_UserID($eRSP_UserID = null)
    {
        $this->ERSP_UserID = $eRSP_UserID;
        return $this;
    }
    /**
     * Get PersonalCityCode value
     * @return string|null
     */
    public function getPersonalCityCode()
    {
        return $this->PersonalCityCode;
    }
    /**
     * Set PersonalCityCode value
     * @param string $personalCityCode
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setPersonalCityCode($personalCityCode = null)
    {
        $this->PersonalCityCode = $personalCityCode;
        return $this;
    }
    /**
     * Get AccountingCode value
     * @return string|null
     */
    public function getAccountingCode()
    {
        return $this->AccountingCode;
    }
    /**
     * Set AccountingCode value
     * @param string $accountingCode
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setAccountingCode($accountingCode = null)
    {
        $this->AccountingCode = $accountingCode;
        return $this;
    }
    /**
     * Get OfficeCode value
     * @return string|null
     */
    public function getOfficeCode()
    {
        return $this->OfficeCode;
    }
    /**
     * Set OfficeCode value
     * @param string $officeCode
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setOfficeCode($officeCode = null)
    {
        $this->OfficeCode = $officeCode;
        return $this;
    }
    /**
     * Get DefaultTicketingCarrier value
     * @return string|null
     */
    public function getDefaultTicketingCarrier()
    {
        return $this->DefaultTicketingCarrier;
    }
    /**
     * Set DefaultTicketingCarrier value
     * @param string $defaultTicketingCarrier
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setDefaultTicketingCarrier($defaultTicketingCarrier = null)
    {
        $this->DefaultTicketingCarrier = $defaultTicketingCarrier;
        return $this;
    }
    /**
     * Get HostCarrier value
     * @return string|null
     */
    public function getHostCarrier()
    {
        return $this->HostCarrier;
    }
    /**
     * Set HostCarrier value
     * @param string $hostCarrier
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setHostCarrier($hostCarrier = null)
    {
        $this->HostCarrier = $hostCarrier;
        return $this;
    }
    /**
     * Get ETicketCapable value
     * @return bool|null
     */
    public function getETicketCapable()
    {
        return $this->ETicketCapable;
    }
    /**
     * Set ETicketCapable value
     * @param bool $eTicketCapable
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setETicketCapable($eTicketCapable = false)
    {
        $this->ETicketCapable = $eTicketCapable;
        return $this;
    }
    /**
     * Get CoHostID value
     * @return int|null
     */
    public function getCoHostID()
    {
        return $this->CoHostID;
    }
    /**
     * Set CoHostID value
     * @param int $coHostID
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public function setCoHostID($coHostID = null)
    {
        $this->CoHostID = $coHostID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ExchangeSourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
