<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiversityControlType StructType
 * Meta information extracted from the WSDL
 * - documentation: These parameters control how IntellSell should select itineraries based not necessarily on cheapest price, but also on other criteria that guarantee a diverse response.
 * @subpackage Structs
 */
class DiversityControlType extends AbstractStructBase
{
    /**
     * The LowFareBucket
     * @var \SabreSoap\StructType\LowFareBucket
     */
    public $LowFareBucket;
    /**
     * The Dimensions
     * @var \SabreSoap\StructType\Dimensions
     */
    public $Dimensions;
    /**
     * Constructor method for DiversityControlType
     * @uses DiversityControlType::setLowFareBucket()
     * @uses DiversityControlType::setDimensions()
     * @param \SabreSoap\StructType\LowFareBucket $lowFareBucket
     * @param \SabreSoap\StructType\Dimensions $dimensions
     */
    public function __construct(\SabreSoap\StructType\LowFareBucket $lowFareBucket = null, \SabreSoap\StructType\Dimensions $dimensions = null)
    {
        $this
            ->setLowFareBucket($lowFareBucket)
            ->setDimensions($dimensions);
    }
    /**
     * Get LowFareBucket value
     * @return \SabreSoap\StructType\LowFareBucket|null
     */
    public function getLowFareBucket()
    {
        return $this->LowFareBucket;
    }
    /**
     * Set LowFareBucket value
     * @param \SabreSoap\StructType\LowFareBucket $lowFareBucket
     * @return \SabreSoap\StructType\DiversityControlType
     */
    public function setLowFareBucket(\SabreSoap\StructType\LowFareBucket $lowFareBucket = null)
    {
        $this->LowFareBucket = $lowFareBucket;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \SabreSoap\StructType\Dimensions|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \SabreSoap\StructType\Dimensions $dimensions
     * @return \SabreSoap\StructType\DiversityControlType
     */
    public function setDimensions(\SabreSoap\StructType\Dimensions $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\DiversityControlType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
