<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyaltyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Program rewarding frequent use by accumulating credits for services provided by vendors.
 * @subpackage Structs
 */
class CustLoyaltyType extends AbstractStructBase
{
    /**
     * The ProgramID
     * Meta information extracted from the WSDL
     * - documentation: Identifier to indicate the company owner of the loyalty program. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the member in the program (membership number, account number, etc.). | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $MembershipID;
    /**
     * The TravelSector
     * Meta information extracted from the WSDL
     * - documentation: Identifies the travel sector. Refer to OTA Code List Travel Sector (TVS). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - use: optional
     * @var string
     */
    public $TravelSector;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Reference place holder, to reference it back in the response. | (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used to assign individual passengers or clients to
     * particular itinerary items.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $RPH;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The LoyalLevel
     * Meta information extracted from the WSDL
     * - documentation: Indicates special privileges in program assigned to individual. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * @var string
     */
    public $LoyalLevel;
    /**
     * The SingleVendorInd
     * @var string
     */
    public $SingleVendorInd;
    /**
     * The SignupDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates when the member signed up for the loyalty program.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $SignupDate;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for CustLoyaltyType
     * @uses CustLoyaltyType::setProgramID()
     * @uses CustLoyaltyType::setMembershipID()
     * @uses CustLoyaltyType::setTravelSector()
     * @uses CustLoyaltyType::setRPH()
     * @uses CustLoyaltyType::setShareSynchInd()
     * @uses CustLoyaltyType::setShareMarketInd()
     * @uses CustLoyaltyType::setLoyalLevel()
     * @uses CustLoyaltyType::setSingleVendorInd()
     * @uses CustLoyaltyType::setSignupDate()
     * @uses CustLoyaltyType::setEffectiveDate()
     * @uses CustLoyaltyType::setExpireDate()
     * @param string $programID
     * @param string $membershipID
     * @param string $travelSector
     * @param string $rPH
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $loyalLevel
     * @param string $singleVendorInd
     * @param string $signupDate
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct($programID = null, $membershipID = null, $travelSector = null, $rPH = null, $shareSynchInd = null, $shareMarketInd = null, $loyalLevel = null, $singleVendorInd = null, $signupDate = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setTravelSector($travelSector)
            ->setRPH($rPH)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setLoyalLevel($loyalLevel)
            ->setSingleVendorInd($singleVendorInd)
            ->setSignupDate($signupDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setMembershipID($membershipID = null)
    {
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setTravelSector($travelSector = null)
    {
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get LoyalLevel value
     * @return string|null
     */
    public function getLoyalLevel()
    {
        return $this->LoyalLevel;
    }
    /**
     * Set LoyalLevel value
     * @param string $loyalLevel
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setLoyalLevel($loyalLevel = null)
    {
        $this->LoyalLevel = $loyalLevel;
        return $this;
    }
    /**
     * Get SingleVendorInd value
     * @return string|null
     */
    public function getSingleVendorInd()
    {
        return $this->SingleVendorInd;
    }
    /**
     * Set SingleVendorInd value
     * @param string $singleVendorInd
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setSingleVendorInd($singleVendorInd = null)
    {
        $this->SingleVendorInd = $singleVendorInd;
        return $this;
    }
    /**
     * Get SignupDate value
     * @return string|null
     */
    public function getSignupDate()
    {
        return $this->SignupDate;
    }
    /**
     * Set SignupDate value
     * @param string $signupDate
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setSignupDate($signupDate = null)
    {
        $this->SignupDate = $signupDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public function setExpireDate($expireDate = null)
    {
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\CustLoyaltyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
