<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CachePartitionGroupType StructType
 * @subpackage Structs
 */
class CachePartitionGroupType extends AbstractStructBase
{
    /**
     * The Partition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \SabreSoap\StructType\CachePartitionType[]
     */
    public $Partition;
    /**
     * Constructor method for CachePartitionGroupType
     * @uses CachePartitionGroupType::setPartition()
     * @param \SabreSoap\StructType\CachePartitionType[] $partition
     */
    public function __construct(array $partition = array())
    {
        $this
            ->setPartition($partition);
    }
    /**
     * Get Partition value
     * @return \SabreSoap\StructType\CachePartitionType[]
     */
    public function getPartition()
    {
        return $this->Partition;
    }
    /**
     * Set Partition value
     * @param \SabreSoap\StructType\CachePartitionType[] $partition
     * @return \SabreSoap\StructType\CachePartitionGroupType
     */
    public function setPartition(array $partition = array())
    {
        $this->Partition = $partition;
        return $this;
    }
    /**
     * Add item to Partition value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\CachePartitionType $item
     * @return \SabreSoap\StructType\CachePartitionGroupType
     */
    public function addToPartition(\SabreSoap\StructType\CachePartitionType $item)
    {
        $this->Partition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\CachePartitionGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
