<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternatePCC StructType
 * @subpackage Structs
 */
class AlternatePCC extends AbstractStructBase
{
    /**
     * The PseudoCityCode
     * Meta information extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system. | Used for Character Strings, length 1 to 16
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The TravelPreferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TravelPreferences
     */
    public $TravelPreferences;
    /**
     * Constructor method for AlternatePCC
     * @uses AlternatePCC::setPseudoCityCode()
     * @uses AlternatePCC::setTravelPreferences()
     * @param string $pseudoCityCode
     * @param \SabreSoap\StructType\TravelPreferences $travelPreferences
     */
    public function __construct($pseudoCityCode = null, \SabreSoap\StructType\TravelPreferences $travelPreferences = null)
    {
        $this
            ->setPseudoCityCode($pseudoCityCode)
            ->setTravelPreferences($travelPreferences);
    }
    /**
     * Get PseudoCityCode value
     * @return string
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \SabreSoap\StructType\AlternatePCC
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get TravelPreferences value
     * @return \SabreSoap\StructType\TravelPreferences|null
     */
    public function getTravelPreferences()
    {
        return $this->TravelPreferences;
    }
    /**
     * Set TravelPreferences value
     * @param \SabreSoap\StructType\TravelPreferences $travelPreferences
     * @return \SabreSoap\StructType\AlternatePCC
     */
    public function setTravelPreferences(\SabreSoap\StructType\TravelPreferences $travelPreferences = null)
    {
        $this->TravelPreferences = $travelPreferences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\AlternatePCC
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
