<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateAirportCities StructType
 * Meta information extracted from the WSDL
 * - documentation: For each specified location provide an alternate location.
 * @subpackage Structs
 */
class AlternateAirportCities extends AbstractStructBase
{
    /**
     * The SpecifiedLocation
     * @var \SabreSoap\StructType\SpecifiedLocation
     */
    public $SpecifiedLocation;
    /**
     * The AlternateLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * @var \SabreSoap\StructType\AlternateLocation[]
     */
    public $AlternateLocation;
    /**
     * Constructor method for AlternateAirportCities
     * @uses AlternateAirportCities::setSpecifiedLocation()
     * @uses AlternateAirportCities::setAlternateLocation()
     * @param \SabreSoap\StructType\SpecifiedLocation $specifiedLocation
     * @param \SabreSoap\StructType\AlternateLocation[] $alternateLocation
     */
    public function __construct(\SabreSoap\StructType\SpecifiedLocation $specifiedLocation = null, array $alternateLocation = array())
    {
        $this
            ->setSpecifiedLocation($specifiedLocation)
            ->setAlternateLocation($alternateLocation);
    }
    /**
     * Get SpecifiedLocation value
     * @return \SabreSoap\StructType\SpecifiedLocation|null
     */
    public function getSpecifiedLocation()
    {
        return $this->SpecifiedLocation;
    }
    /**
     * Set SpecifiedLocation value
     * @param \SabreSoap\StructType\SpecifiedLocation $specifiedLocation
     * @return \SabreSoap\StructType\AlternateAirportCities
     */
    public function setSpecifiedLocation(\SabreSoap\StructType\SpecifiedLocation $specifiedLocation = null)
    {
        $this->SpecifiedLocation = $specifiedLocation;
        return $this;
    }
    /**
     * Get AlternateLocation value
     * @return \SabreSoap\StructType\AlternateLocation[]|null
     */
    public function getAlternateLocation()
    {
        return $this->AlternateLocation;
    }
    /**
     * Set AlternateLocation value
     * @param \SabreSoap\StructType\AlternateLocation[] $alternateLocation
     * @return \SabreSoap\StructType\AlternateAirportCities
     */
    public function setAlternateLocation(array $alternateLocation = array())
    {
        $this->AlternateLocation = $alternateLocation;
        return $this;
    }
    /**
     * Add item to AlternateLocation value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\AlternateLocation $item
     * @return \SabreSoap\StructType\AlternateAirportCities
     */
    public function addToAlternateLocation(\SabreSoap\StructType\AlternateLocation $item)
    {
        $this->AlternateLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\AlternateAirportCities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
