<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueBucket StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional information for Value Bucket sorting
 * @subpackage Structs
 */
class ValueBucket extends AbstractStructBase
{
    /**
     * The PriceTimeValueRank
     * Meta information extracted from the WSDL
     * - documentation: Price Time Value rank.
     * @var float
     */
    public $PriceTimeValueRank;
    /**
     * The ValueBucketNumber
     * Meta information extracted from the WSDL
     * - documentation: Price Time Value Bucket number.
     * @var int
     */
    public $ValueBucketNumber;
    /**
     * Constructor method for ValueBucket
     * @uses ValueBucket::setPriceTimeValueRank()
     * @uses ValueBucket::setValueBucketNumber()
     * @param float $priceTimeValueRank
     * @param int $valueBucketNumber
     */
    public function __construct($priceTimeValueRank = null, $valueBucketNumber = null)
    {
        $this
            ->setPriceTimeValueRank($priceTimeValueRank)
            ->setValueBucketNumber($valueBucketNumber);
    }
    /**
     * Get PriceTimeValueRank value
     * @return float|null
     */
    public function getPriceTimeValueRank()
    {
        return $this->PriceTimeValueRank;
    }
    /**
     * Set PriceTimeValueRank value
     * @param float $priceTimeValueRank
     * @return \SabreSoap\StructType\ValueBucket
     */
    public function setPriceTimeValueRank($priceTimeValueRank = null)
    {
        $this->PriceTimeValueRank = $priceTimeValueRank;
        return $this;
    }
    /**
     * Get ValueBucketNumber value
     * @return int|null
     */
    public function getValueBucketNumber()
    {
        return $this->ValueBucketNumber;
    }
    /**
     * Set ValueBucketNumber value
     * @param int $valueBucketNumber
     * @return \SabreSoap\StructType\ValueBucket
     */
    public function setValueBucketNumber($valueBucketNumber = null)
    {
        $this->ValueBucketNumber = $valueBucketNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ValueBucket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
