<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsernameToken StructType
 * @subpackage Structs
 */
class UsernameToken extends AbstractStructBase
{
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The NewPassword
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $NewPassword;
    /**
     * The Organization
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - minOccurs: 0
     * @var string
     */
    public $Organization;
    /**
     * The Domain
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - minOccurs: 0
     * @var string
     */
    public $Domain;
    /**
     * Constructor method for UsernameToken
     * @uses UsernameToken::setUsername()
     * @uses UsernameToken::setPassword()
     * @uses UsernameToken::setNewPassword()
     * @uses UsernameToken::setOrganization()
     * @uses UsernameToken::setDomain()
     * @param string $username
     * @param string $password
     * @param string[] $newPassword
     * @param string $organization
     * @param string $domain
     */
    public function __construct($username = null, $password = null, array $newPassword = array(), $organization = null, $domain = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setNewPassword($newPassword)
            ->setOrganization($organization)
            ->setDomain($domain);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \SabreSoap\StructType\UsernameToken
     */
    public function setUsername($username = null)
    {
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \SabreSoap\StructType\UsernameToken
     */
    public function setPassword($password = null)
    {
        $this->Password = $password;
        return $this;
    }
    /**
     * Get NewPassword value
     * @return string[]|null
     */
    public function getNewPassword()
    {
        return $this->NewPassword;
    }
    /**
     * Set NewPassword value
     * @param string[] $newPassword
     * @return \SabreSoap\StructType\UsernameToken
     */
    public function setNewPassword(array $newPassword = array())
    {
        $this->NewPassword = $newPassword;
        return $this;
    }
    /**
     * Add item to NewPassword value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabreSoap\StructType\UsernameToken
     */
    public function addToNewPassword($item)
    {
        $this->NewPassword[] = $item;
        return $this;
    }
    /**
     * Get Organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * Set Organization value
     * @param string $organization
     * @return \SabreSoap\StructType\UsernameToken
     */
    public function setOrganization($organization = null)
    {
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Get Domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param string $domain
     * @return \SabreSoap\StructType\UsernameToken
     */
    public function setDomain($domain = null)
    {
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\UsernameToken
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
