<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerCountType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the number of travelers. | Defines the number of travelers of a specific type (e.g. a driver type can be either one of: Adult, YoungDriver, YoungerDriver, or it may be a code that is acceptable to both Trading Partners).
 * @subpackage Structs
 */
class TravelerCountType extends AbstractStructBase
{
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 0 to 999 inclusive
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $Age;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Identifies the source authority for the code. | Used for Character Strings, length 1 to 32
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CodeContext;
    /**
     * The URI
     * Meta information extracted from the WSDL
     * - documentation: Identifies the location of the code table
     * - use: optional
     * @var string
     */
    public $URI;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Used to define a quantity of an associated element or attribute. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for TravelerCountType
     * @uses TravelerCountType::setAge()
     * @uses TravelerCountType::setCode()
     * @uses TravelerCountType::setCodeContext()
     * @uses TravelerCountType::setURI()
     * @uses TravelerCountType::setQuantity()
     * @param int $age
     * @param string $code
     * @param string $codeContext
     * @param string $uRI
     * @param int $quantity
     */
    public function __construct($age = null, $code = null, $codeContext = null, $uRI = null, $quantity = null)
    {
        $this
            ->setAge($age)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setURI($uRI)
            ->setQuantity($quantity);
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \SabreSoap\StructType\TravelerCountType
     */
    public function setAge($age = null)
    {
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \SabreSoap\StructType\TravelerCountType
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \SabreSoap\StructType\TravelerCountType
     */
    public function setCodeContext($codeContext = null)
    {
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \SabreSoap\StructType\TravelerCountType
     */
    public function setURI($uRI = null)
    {
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \SabreSoap\StructType\TravelerCountType
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\TravelerCountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
