<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeOfDayDistribution StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines how the options in the response should be distributed between certain departure time of day ranges. All defined TimeOfDayRanges need to cover the whole day and the sum of all Percentages needs to equal 100.
 * @subpackage Structs
 */
class TimeOfDayDistribution extends AbstractStructBase
{
    /**
     * The TimeOfDayRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 2
     * @var \SabreSoap\StructType\TimeOfDayRange[]
     */
    public $TimeOfDayRange;
    /**
     * Constructor method for TimeOfDayDistribution
     * @uses TimeOfDayDistribution::setTimeOfDayRange()
     * @param \SabreSoap\StructType\TimeOfDayRange[] $timeOfDayRange
     */
    public function __construct(array $timeOfDayRange = array())
    {
        $this
            ->setTimeOfDayRange($timeOfDayRange);
    }
    /**
     * Get TimeOfDayRange value
     * @return \SabreSoap\StructType\TimeOfDayRange[]
     */
    public function getTimeOfDayRange()
    {
        return $this->TimeOfDayRange;
    }
    /**
     * Set TimeOfDayRange value
     * @param \SabreSoap\StructType\TimeOfDayRange[] $timeOfDayRange
     * @return \SabreSoap\StructType\TimeOfDayDistribution
     */
    public function setTimeOfDayRange(array $timeOfDayRange = array())
    {
        $this->TimeOfDayRange = $timeOfDayRange;
        return $this;
    }
    /**
     * Add item to TimeOfDayRange value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\TimeOfDayRange $item
     * @return \SabreSoap\StructType\TimeOfDayDistribution
     */
    public function addToTimeOfDayRange(\SabreSoap\StructType\TimeOfDayRange $item)
    {
        $this->TimeOfDayRange[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\TimeOfDayDistribution
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
