<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeOfDay StructType
 * @subpackage Structs
 */
class TimeOfDay extends AbstractStructBase
{
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - base: xs:integer
     * - maxInclusive: 10
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $Weight;
    /**
     * The Distribution
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\Distribution[]
     */
    public $Distribution;
    /**
     * Constructor method for TimeOfDay
     * @uses TimeOfDay::setWeight()
     * @uses TimeOfDay::setDistribution()
     * @param int $weight
     * @param \SabreSoap\StructType\Distribution[] $distribution
     */
    public function __construct($weight = null, array $distribution = array())
    {
        $this
            ->setWeight($weight)
            ->setDistribution($distribution);
    }
    /**
     * Get Weight value
     * @return int
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \SabreSoap\StructType\TimeOfDay
     */
    public function setWeight($weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Distribution value
     * @return \SabreSoap\StructType\Distribution[]|null
     */
    public function getDistribution()
    {
        return $this->Distribution;
    }
    /**
     * Set Distribution value
     * @param \SabreSoap\StructType\Distribution[] $distribution
     * @return \SabreSoap\StructType\TimeOfDay
     */
    public function setDistribution(array $distribution = array())
    {
        $this->Distribution = $distribution;
        return $this;
    }
    /**
     * Add item to Distribution value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Distribution $item
     * @return \SabreSoap\StructType\TimeOfDay
     */
    public function addToDistribution(\SabreSoap\StructType\Distribution $item)
    {
        $this->Distribution[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\TimeOfDay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
