<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketPricingType StructType
 * Meta information extracted from the WSDL
 * - documentation: Pricing Information for Single Ticket
 * @subpackage Structs
 */
class TicketPricingType extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Ticket position related to entire itinerary
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The OriginDestinationOptions
     * @var \SabreSoap\StructType\OriginDestinationOptions
     */
    public $OriginDestinationOptions;
    /**
     * The AirItineraryPricingInfo
     * Meta information extracted from the WSDL
     * - documentation: Pricing Information for a Ticket.
     * @var \SabreSoap\StructType\AirItineraryPricingInfoType
     */
    public $AirItineraryPricingInfo;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - documentation: Provides for free form descriptive information for the priced itinerary.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \SabreSoap\StructType\FreeTextType[]
     */
    public $Notes;
    /**
     * The TicketingInfo
     * Meta information extracted from the WSDL
     * - documentation: Container for TicketingInfoRS_Type.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TicketingInfoRS_Type
     */
    public $TicketingInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * Constructor method for TicketPricingType
     * @uses TicketPricingType::setNumber()
     * @uses TicketPricingType::setOriginDestinationOptions()
     * @uses TicketPricingType::setAirItineraryPricingInfo()
     * @uses TicketPricingType::setNotes()
     * @uses TicketPricingType::setTicketingInfo()
     * @uses TicketPricingType::setTPA_Extensions()
     * @param int $number
     * @param \SabreSoap\StructType\OriginDestinationOptions $originDestinationOptions
     * @param \SabreSoap\StructType\AirItineraryPricingInfoType $airItineraryPricingInfo
     * @param \SabreSoap\StructType\FreeTextType[] $notes
     * @param \SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     */
    public function __construct($number = null, \SabreSoap\StructType\OriginDestinationOptions $originDestinationOptions = null, \SabreSoap\StructType\AirItineraryPricingInfoType $airItineraryPricingInfo = null, array $notes = array(), \SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this
            ->setNumber($number)
            ->setOriginDestinationOptions($originDestinationOptions)
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setNotes($notes)
            ->setTicketingInfo($ticketingInfo)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \SabreSoap\StructType\TicketPricingType
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get OriginDestinationOptions value
     * @return \SabreSoap\StructType\OriginDestinationOptions|null
     */
    public function getOriginDestinationOptions()
    {
        return $this->OriginDestinationOptions;
    }
    /**
     * Set OriginDestinationOptions value
     * @param \SabreSoap\StructType\OriginDestinationOptions $originDestinationOptions
     * @return \SabreSoap\StructType\TicketPricingType
     */
    public function setOriginDestinationOptions(\SabreSoap\StructType\OriginDestinationOptions $originDestinationOptions = null)
    {
        $this->OriginDestinationOptions = $originDestinationOptions;
        return $this;
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \SabreSoap\StructType\AirItineraryPricingInfoType|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @param \SabreSoap\StructType\AirItineraryPricingInfoType $airItineraryPricingInfo
     * @return \SabreSoap\StructType\TicketPricingType
     */
    public function setAirItineraryPricingInfo(\SabreSoap\StructType\AirItineraryPricingInfoType $airItineraryPricingInfo = null)
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Get Notes value
     * @return \SabreSoap\StructType\FreeTextType[]|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \SabreSoap\StructType\FreeTextType[] $notes
     * @return \SabreSoap\StructType\TicketPricingType
     */
    public function setNotes(array $notes = array())
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Add item to Notes value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\FreeTextType $item
     * @return \SabreSoap\StructType\TicketPricingType
     */
    public function addToNotes(\SabreSoap\StructType\FreeTextType $item)
    {
        $this->Notes[] = $item;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \SabreSoap\StructType\TicketingInfoRS_Type|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo
     * @return \SabreSoap\StructType\TicketPricingType
     */
    public function setTicketingInfo(\SabreSoap\StructType\TicketingInfoRS_Type $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\TicketPricingType
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\TicketPricingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
