<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceBookingChannelType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the booking channel type and whether it is the primary means of connectivity of the source.
 * @subpackage Structs
 */
class SourceBookingChannelType extends BookingChannelType
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: Identifies the company that is associated with the booking channel.
     * - minOccurs: 0
     * @var \SabreSoap\StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * Constructor method for SourceBookingChannelType
     * @uses SourceBookingChannelType::setCompanyName()
     * @param \SabreSoap\StructType\CompanyNameType $companyName
     */
    public function __construct(\SabreSoap\StructType\CompanyNameType $companyName = null)
    {
        $this
            ->setCompanyName($companyName);
    }
    /**
     * Get CompanyName value
     * @return \SabreSoap\StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \SabreSoap\StructType\CompanyNameType $companyName
     * @return \SabreSoap\StructType\SourceBookingChannelType
     */
    public function setCompanyName(\SabreSoap\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\SourceBookingChannelType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
