<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleOneWayItineraries StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for priced itineraries assigned to particular leg.
 * @subpackage Structs
 */
class SimpleOneWayItineraries extends AbstractStructBase
{
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Leg ID from request. | (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: required
     * @var string
     */
    public $RPH;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The PricedItinerary
     * Meta information extracted from the WSDL
     * - documentation: Container for priced itinerary type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabreSoap\StructType\PricedItineraryType[]
     */
    public $PricedItinerary;
    /**
     * Constructor method for SimpleOneWayItineraries
     * @uses SimpleOneWayItineraries::setRPH()
     * @uses SimpleOneWayItineraries::setTPA_Extensions()
     * @uses SimpleOneWayItineraries::setPricedItinerary()
     * @param string $rPH
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @param \SabreSoap\StructType\PricedItineraryType[] $pricedItinerary
     */
    public function __construct($rPH = null, \SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null, array $pricedItinerary = array())
    {
        $this
            ->setRPH($rPH)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPricedItinerary($pricedItinerary);
    }
    /**
     * Get RPH value
     * @return string
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \SabreSoap\StructType\SimpleOneWayItineraries
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \SabreSoap\StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \SabreSoap\StructType\TPA_Extensions $tPA_Extensions
     * @return \SabreSoap\StructType\SimpleOneWayItineraries
     */
    public function setTPA_Extensions(\SabreSoap\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PricedItinerary value
     * @return \SabreSoap\StructType\PricedItineraryType[]|null
     */
    public function getPricedItinerary()
    {
        return $this->PricedItinerary;
    }
    /**
     * Set PricedItinerary value
     * @param \SabreSoap\StructType\PricedItineraryType[] $pricedItinerary
     * @return \SabreSoap\StructType\SimpleOneWayItineraries
     */
    public function setPricedItinerary(array $pricedItinerary = array())
    {
        $this->PricedItinerary = $pricedItinerary;
        return $this;
    }
    /**
     * Add item to PricedItinerary value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\PricedItineraryType $item
     * @return \SabreSoap\StructType\SimpleOneWayItineraries
     */
    public function addToPricedItinerary(\SabreSoap\StructType\PricedItineraryType $item)
    {
        $this->PricedItinerary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\SimpleOneWayItineraries
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
