<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReissueInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the data fields available for the reissue info type
 * @subpackage Structs
 */
class ReissueInfoType extends AbstractStructBase
{
    /**
     * The ChangeFees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabreSoap\StructType\ChangeFees
     */
    public $ChangeFees;
    /**
     * The ResidualIdicator
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResidualIdicator;
    /**
     * The TypeOfServiceFee
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TypeOfServiceFee;
    /**
     * The TypeOfReissueTransaction
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TypeOfReissueTransaction;
    /**
     * The ReissueResultFromTag
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReissueResultFromTag;
    /**
     * The FormOfRefund
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FormOfRefund;
    /**
     * The ReissueRequiresElectronicTicket
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReissueRequiresElectronicTicket;
    /**
     * The ReissueDoesNotAllowElectronicTicket
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReissueDoesNotAllowElectronicTicket;
    /**
     * The TaxRefundable
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $TaxRefundable;
    /**
     * Constructor method for ReissueInfoType
     * @uses ReissueInfoType::setChangeFees()
     * @uses ReissueInfoType::setResidualIdicator()
     * @uses ReissueInfoType::setTypeOfServiceFee()
     * @uses ReissueInfoType::setTypeOfReissueTransaction()
     * @uses ReissueInfoType::setReissueResultFromTag()
     * @uses ReissueInfoType::setFormOfRefund()
     * @uses ReissueInfoType::setReissueRequiresElectronicTicket()
     * @uses ReissueInfoType::setReissueDoesNotAllowElectronicTicket()
     * @uses ReissueInfoType::setTaxRefundable()
     * @param \SabreSoap\StructType\ChangeFees $changeFees
     * @param string $residualIdicator
     * @param string $typeOfServiceFee
     * @param string $typeOfReissueTransaction
     * @param bool $reissueResultFromTag
     * @param string $formOfRefund
     * @param bool $reissueRequiresElectronicTicket
     * @param bool $reissueDoesNotAllowElectronicTicket
     * @param bool $taxRefundable
     */
    public function __construct(\SabreSoap\StructType\ChangeFees $changeFees = null, $residualIdicator = null, $typeOfServiceFee = null, $typeOfReissueTransaction = null, $reissueResultFromTag = null, $formOfRefund = null, $reissueRequiresElectronicTicket = null, $reissueDoesNotAllowElectronicTicket = null, $taxRefundable = null)
    {
        $this
            ->setChangeFees($changeFees)
            ->setResidualIdicator($residualIdicator)
            ->setTypeOfServiceFee($typeOfServiceFee)
            ->setTypeOfReissueTransaction($typeOfReissueTransaction)
            ->setReissueResultFromTag($reissueResultFromTag)
            ->setFormOfRefund($formOfRefund)
            ->setReissueRequiresElectronicTicket($reissueRequiresElectronicTicket)
            ->setReissueDoesNotAllowElectronicTicket($reissueDoesNotAllowElectronicTicket)
            ->setTaxRefundable($taxRefundable);
    }
    /**
     * Get ChangeFees value
     * @return \SabreSoap\StructType\ChangeFees|null
     */
    public function getChangeFees()
    {
        return $this->ChangeFees;
    }
    /**
     * Set ChangeFees value
     * @param \SabreSoap\StructType\ChangeFees $changeFees
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public function setChangeFees(\SabreSoap\StructType\ChangeFees $changeFees = null)
    {
        $this->ChangeFees = $changeFees;
        return $this;
    }
    /**
     * Get ResidualIdicator value
     * @return string|null
     */
    public function getResidualIdicator()
    {
        return $this->ResidualIdicator;
    }
    /**
     * Set ResidualIdicator value
     * @param string $residualIdicator
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public function setResidualIdicator($residualIdicator = null)
    {
        $this->ResidualIdicator = $residualIdicator;
        return $this;
    }
    /**
     * Get TypeOfServiceFee value
     * @return string|null
     */
    public function getTypeOfServiceFee()
    {
        return $this->TypeOfServiceFee;
    }
    /**
     * Set TypeOfServiceFee value
     * @param string $typeOfServiceFee
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public function setTypeOfServiceFee($typeOfServiceFee = null)
    {
        $this->TypeOfServiceFee = $typeOfServiceFee;
        return $this;
    }
    /**
     * Get TypeOfReissueTransaction value
     * @return string|null
     */
    public function getTypeOfReissueTransaction()
    {
        return $this->TypeOfReissueTransaction;
    }
    /**
     * Set TypeOfReissueTransaction value
     * @param string $typeOfReissueTransaction
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public function setTypeOfReissueTransaction($typeOfReissueTransaction = null)
    {
        $this->TypeOfReissueTransaction = $typeOfReissueTransaction;
        return $this;
    }
    /**
     * Get ReissueResultFromTag value
     * @return bool|null
     */
    public function getReissueResultFromTag()
    {
        return $this->ReissueResultFromTag;
    }
    /**
     * Set ReissueResultFromTag value
     * @param bool $reissueResultFromTag
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public function setReissueResultFromTag($reissueResultFromTag = null)
    {
        $this->ReissueResultFromTag = $reissueResultFromTag;
        return $this;
    }
    /**
     * Get FormOfRefund value
     * @return string|null
     */
    public function getFormOfRefund()
    {
        return $this->FormOfRefund;
    }
    /**
     * Set FormOfRefund value
     * @param string $formOfRefund
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public function setFormOfRefund($formOfRefund = null)
    {
        $this->FormOfRefund = $formOfRefund;
        return $this;
    }
    /**
     * Get ReissueRequiresElectronicTicket value
     * @return bool|null
     */
    public function getReissueRequiresElectronicTicket()
    {
        return $this->ReissueRequiresElectronicTicket;
    }
    /**
     * Set ReissueRequiresElectronicTicket value
     * @param bool $reissueRequiresElectronicTicket
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public function setReissueRequiresElectronicTicket($reissueRequiresElectronicTicket = null)
    {
        $this->ReissueRequiresElectronicTicket = $reissueRequiresElectronicTicket;
        return $this;
    }
    /**
     * Get ReissueDoesNotAllowElectronicTicket value
     * @return bool|null
     */
    public function getReissueDoesNotAllowElectronicTicket()
    {
        return $this->ReissueDoesNotAllowElectronicTicket;
    }
    /**
     * Set ReissueDoesNotAllowElectronicTicket value
     * @param bool $reissueDoesNotAllowElectronicTicket
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public function setReissueDoesNotAllowElectronicTicket($reissueDoesNotAllowElectronicTicket = null)
    {
        $this->ReissueDoesNotAllowElectronicTicket = $reissueDoesNotAllowElectronicTicket;
        return $this;
    }
    /**
     * Get TaxRefundable value
     * @return bool|null
     */
    public function getTaxRefundable()
    {
        return $this->TaxRefundable;
    }
    /**
     * Set TaxRefundable value
     * @param bool $taxRefundable
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public function setTaxRefundable($taxRefundable = null)
    {
        $this->TaxRefundable = $taxRefundable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ReissueInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
