<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReissueInfoList StructType
 * Meta information extracted from the WSDL
 * - documentation: Reissue information
 * @subpackage Structs
 */
class ReissueInfoList extends AbstractStructBase
{
    /**
     * The ReissueInfo
     * Meta information extracted from the WSDL
     * - documentation: Reissue Info
     * - maxOccurs: unbounded
     * @var \SabreSoap\StructType\ReissueInfoType[]
     */
    public $ReissueInfo;
    /**
     * Constructor method for ReissueInfoList
     * @uses ReissueInfoList::setReissueInfo()
     * @param \SabreSoap\StructType\ReissueInfoType[] $reissueInfo
     */
    public function __construct(array $reissueInfo = array())
    {
        $this
            ->setReissueInfo($reissueInfo);
    }
    /**
     * Get ReissueInfo value
     * @return \SabreSoap\StructType\ReissueInfoType[]|null
     */
    public function getReissueInfo()
    {
        return $this->ReissueInfo;
    }
    /**
     * Set ReissueInfo value
     * @param \SabreSoap\StructType\ReissueInfoType[] $reissueInfo
     * @return \SabreSoap\StructType\ReissueInfoList
     */
    public function setReissueInfo(array $reissueInfo = array())
    {
        $this->ReissueInfo = $reissueInfo;
        return $this;
    }
    /**
     * Add item to ReissueInfo value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\ReissueInfoType $item
     * @return \SabreSoap\StructType\ReissueInfoList
     */
    public function addToReissueInfo(\SabreSoap\StructType\ReissueInfoType $item)
    {
        $this->ReissueInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ReissueInfoList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
