<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceType StructType
 * @subpackage Structs
 */
class ReferenceType extends AbstractStructBase
{
    /**
     * The Transforms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Transforms
     * @var \SabreSoap\StructType\TransformsType
     */
    public $Transforms;
    /**
     * The DigestMethod
     * Meta information extracted from the WSDL
     * - ref: ds:DigestMethod
     * @var \SabreSoap\StructType\DigestMethodType
     */
    public $DigestMethod;
    /**
     * The DigestValue
     * Meta information extracted from the WSDL
     * - base: base64Binary
     * - ref: ds:DigestValue
     * @var string
     */
    public $DigestValue;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The URI
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $URI;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for ReferenceType
     * @uses ReferenceType::setTransforms()
     * @uses ReferenceType::setDigestMethod()
     * @uses ReferenceType::setDigestValue()
     * @uses ReferenceType::setId()
     * @uses ReferenceType::setURI()
     * @uses ReferenceType::setType()
     * @param \SabreSoap\StructType\TransformsType $transforms
     * @param \SabreSoap\StructType\DigestMethodType $digestMethod
     * @param string $digestValue
     * @param string $id
     * @param string $uRI
     * @param string $type
     */
    public function __construct(\SabreSoap\StructType\TransformsType $transforms = null, \SabreSoap\StructType\DigestMethodType $digestMethod = null, $digestValue = null, $id = null, $uRI = null, $type = null)
    {
        $this
            ->setTransforms($transforms)
            ->setDigestMethod($digestMethod)
            ->setDigestValue($digestValue)
            ->setId($id)
            ->setURI($uRI)
            ->setType($type);
    }
    /**
     * Get Transforms value
     * @return \SabreSoap\StructType\TransformsType|null
     */
    public function getTransforms()
    {
        return $this->Transforms;
    }
    /**
     * Set Transforms value
     * @param \SabreSoap\StructType\TransformsType $transforms
     * @return \SabreSoap\StructType\ReferenceType
     */
    public function setTransforms(\SabreSoap\StructType\TransformsType $transforms = null)
    {
        $this->Transforms = $transforms;
        return $this;
    }
    /**
     * Get DigestMethod value
     * @return \SabreSoap\StructType\DigestMethodType|null
     */
    public function getDigestMethod()
    {
        return $this->DigestMethod;
    }
    /**
     * Set DigestMethod value
     * @param \SabreSoap\StructType\DigestMethodType $digestMethod
     * @return \SabreSoap\StructType\ReferenceType
     */
    public function setDigestMethod(\SabreSoap\StructType\DigestMethodType $digestMethod = null)
    {
        $this->DigestMethod = $digestMethod;
        return $this;
    }
    /**
     * Get DigestValue value
     * @return string|null
     */
    public function getDigestValue()
    {
        return $this->DigestValue;
    }
    /**
     * Set DigestValue value
     * @param string $digestValue
     * @return \SabreSoap\StructType\ReferenceType
     */
    public function setDigestValue($digestValue = null)
    {
        $this->DigestValue = $digestValue;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabreSoap\StructType\ReferenceType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \SabreSoap\StructType\ReferenceType
     */
    public function setURI($uRI = null)
    {
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\ReferenceType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\ReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
