<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reference StructType
 * Meta information extracted from the WSDL
 * - type: ds:ReferenceType
 * @subpackage Structs
 */
class Reference extends AbstractStructBase
{
    /**
     * The href
     * Meta information extracted from the WSDL
     * - ref: xlink:href
     * - use: required
     * @var string
     */
    public $href;
    /**
     * The Schema
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Schema
     * @var \SabreSoap\StructType\Schema[]
     */
    public $Schema;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \SabreSoap\StructType\Description[]
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - ref: tns:id
     * @var string
     */
    public $id;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - fixed: simple
     * - ref: xlink:type
     * @var string
     */
    public $type;
    /**
     * The role
     * Meta information extracted from the WSDL
     * - ref: xlink:role
     * @var string
     */
    public $role;
    /**
     * Constructor method for Reference
     * @uses Reference::setHref()
     * @uses Reference::setSchema()
     * @uses Reference::setDescription()
     * @uses Reference::setAny()
     * @uses Reference::setId()
     * @uses Reference::setType()
     * @uses Reference::setRole()
     * @param string $href
     * @param \SabreSoap\StructType\Schema[] $schema
     * @param \SabreSoap\StructType\Description[] $description
     * @param \DOMDocument $any
     * @param string $id
     * @param string $type
     * @param string $role
     */
    public function __construct($href = null, array $schema = array(), array $description = array(), \DOMDocument $any = null, $id = null, $type = null, $role = null)
    {
        $this
            ->setHref($href)
            ->setSchema($schema)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setType($type)
            ->setRole($role);
    }
    /**
     * Get href value
     * @return string
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param string $href
     * @return \SabreSoap\StructType\Reference
     */
    public function setHref($href = null)
    {
        $this->href = $href;
        return $this;
    }
    /**
     * Get Schema value
     * @return \SabreSoap\StructType\Schema[]|null
     */
    public function getSchema()
    {
        return $this->Schema;
    }
    /**
     * Set Schema value
     * @param \SabreSoap\StructType\Schema[] $schema
     * @return \SabreSoap\StructType\Reference
     */
    public function setSchema(array $schema = array())
    {
        $this->Schema = $schema;
        return $this;
    }
    /**
     * Add item to Schema value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Schema $item
     * @return \SabreSoap\StructType\Reference
     */
    public function addToSchema(\SabreSoap\StructType\Schema $item)
    {
        $this->Schema[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \SabreSoap\StructType\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \SabreSoap\StructType\Description[] $description
     * @return \SabreSoap\StructType\Reference
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\Description $item
     * @return \SabreSoap\StructType\Reference
     */
    public function addToDescription(\SabreSoap\StructType\Description $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabreSoap\StructType\Reference
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabreSoap\StructType\Reference
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \SabreSoap\StructType\Reference
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \SabreSoap\StructType\Reference
     */
    public function setRole($role = null)
    {
        $this->role = $role;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Reference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
