<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Penalty StructType
 * Meta information extracted from the WSDL
 * - documentation: The penalty charge defined a fee in terms of its amount, currency and decimal laces. | Specifies penalty charges as either a currency amount or a percentage of the fare. | Penalty Info
 * @subpackage Structs
 */
class Penalty extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Exclude
     * Meta information extracted from the WSDL
     * - documentation: Indicate that specific penalty type should be excluded from the response.
     * - use: optional
     * @var bool
     */
    public $Exclude;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - type: Money
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: A currency code (e.g. USD, EUR, PLN) | Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * Meta information extracted from the WSDL
     * - documentation: Indicates the number of decimal places for a particular currency. This is equivalent to the ISO 4217 standard "minor unit".
     * - type: xs:nonNegativeInteger
     * - use: optional
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The PenaltyType
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of penalty involved in the search or response.
     * - use: optional
     * @var string
     */
    public $PenaltyType;
    /**
     * The DepartureStatus
     * Meta information extracted from the WSDL
     * - documentation: Identifier used to indicate whether the change occurs before or after departure from the origin city.
     * - use: optional
     * @var string
     */
    public $DepartureStatus;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: The penalty charge conveyed as a percent of the total fare. | Used for percentage values
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.01
     * @var float
     */
    public $Percent;
    /**
     * The Applicability
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Applicability;
    /**
     * The NonApplicable
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $NonApplicable;
    /**
     * The Cat16Info
     * Meta information extracted from the WSDL
     * - default: false
     * - use: optional
     * @var bool
     */
    public $Cat16Info;
    /**
     * Constructor method for Penalty
     * @uses Penalty::setType()
     * @uses Penalty::setExclude()
     * @uses Penalty::setAmount()
     * @uses Penalty::setCurrencyCode()
     * @uses Penalty::setDecimalPlaces()
     * @uses Penalty::setPenaltyType()
     * @uses Penalty::setDepartureStatus()
     * @uses Penalty::setPercent()
     * @uses Penalty::setApplicability()
     * @uses Penalty::setNonApplicable()
     * @uses Penalty::setCat16Info()
     * @param string $type
     * @param bool $exclude
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $penaltyType
     * @param string $departureStatus
     * @param float $percent
     * @param string $applicability
     * @param bool $nonApplicable
     * @param bool $cat16Info
     */
    public function __construct($type = null, $exclude = null, $amount = null, $currencyCode = null, $decimalPlaces = null, $penaltyType = null, $departureStatus = null, $percent = null, $applicability = null, $nonApplicable = false, $cat16Info = false)
    {
        $this
            ->setType($type)
            ->setExclude($exclude)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setPenaltyType($penaltyType)
            ->setDepartureStatus($departureStatus)
            ->setPercent($percent)
            ->setApplicability($applicability)
            ->setNonApplicable($nonApplicable)
            ->setCat16Info($cat16Info);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\Penalty
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Exclude value
     * @return bool|null
     */
    public function getExclude()
    {
        return $this->Exclude;
    }
    /**
     * Set Exclude value
     * @param bool $exclude
     * @return \SabreSoap\StructType\Penalty
     */
    public function setExclude($exclude = null)
    {
        $this->Exclude = $exclude;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SabreSoap\StructType\Penalty
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabreSoap\StructType\Penalty
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \SabreSoap\StructType\Penalty
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get PenaltyType value
     * @return string|null
     */
    public function getPenaltyType()
    {
        return $this->PenaltyType;
    }
    /**
     * Set PenaltyType value
     * @param string $penaltyType
     * @return \SabreSoap\StructType\Penalty
     */
    public function setPenaltyType($penaltyType = null)
    {
        $this->PenaltyType = $penaltyType;
        return $this;
    }
    /**
     * Get DepartureStatus value
     * @return string|null
     */
    public function getDepartureStatus()
    {
        return $this->DepartureStatus;
    }
    /**
     * Set DepartureStatus value
     * @param string $departureStatus
     * @return \SabreSoap\StructType\Penalty
     */
    public function setDepartureStatus($departureStatus = null)
    {
        $this->DepartureStatus = $departureStatus;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \SabreSoap\StructType\Penalty
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Applicability value
     * @return string|null
     */
    public function getApplicability()
    {
        return $this->Applicability;
    }
    /**
     * Set Applicability value
     * @param string $applicability
     * @return \SabreSoap\StructType\Penalty
     */
    public function setApplicability($applicability = null)
    {
        $this->Applicability = $applicability;
        return $this;
    }
    /**
     * Get NonApplicable value
     * @return bool|null
     */
    public function getNonApplicable()
    {
        return $this->NonApplicable;
    }
    /**
     * Set NonApplicable value
     * @param bool $nonApplicable
     * @return \SabreSoap\StructType\Penalty
     */
    public function setNonApplicable($nonApplicable = false)
    {
        $this->NonApplicable = $nonApplicable;
        return $this;
    }
    /**
     * Get Cat16Info value
     * @return bool|null
     */
    public function getCat16Info()
    {
        return $this->Cat16Info;
    }
    /**
     * Set Cat16Info value
     * @param bool $cat16Info
     * @return \SabreSoap\StructType\Penalty
     */
    public function setCat16Info($cat16Info = false)
    {
        $this->Cat16Info = $cat16Info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Penalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
