<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerStatus StructType
 * @subpackage Structs
 */
class PassengerStatus extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The StateCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8 | The postal service standard code or abbreviation for the state, province, or region.
     * - base: StringLength1to8
     * - choice: StateCode | CountryCode | CityCode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 8
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $StateCode;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - choice: StateCode | CountryCode | CityCode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [a-zA-Z]{2}
     * @var string
     */
    public $CountryCode;
    /**
     * The CityCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Alphabetic Strings, length exactly 3
     * - base: xs:string
     * - choice: StateCode | CountryCode | CityCode
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CityCode;
    /**
     * Constructor method for PassengerStatus
     * @uses PassengerStatus::setType()
     * @uses PassengerStatus::setStateCode()
     * @uses PassengerStatus::setCountryCode()
     * @uses PassengerStatus::setCityCode()
     * @param string $type
     * @param string $stateCode
     * @param string $countryCode
     * @param string $cityCode
     */
    public function __construct($type = null, $stateCode = null, $countryCode = null, $cityCode = null)
    {
        $this
            ->setType($type)
            ->setStateCode($stateCode)
            ->setCountryCode($countryCode)
            ->setCityCode($cityCode);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabreSoap\StructType\PassengerStatus
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return isset($this->StateCode) ? $this->StateCode : null;
    }
    /**
     * Set StateCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $stateCode
     * @return \SabreSoap\StructType\PassengerStatus
     */
    public function setStateCode($stateCode = null)
    {
        if (is_null($stateCode) || (is_array($stateCode) && empty($stateCode))) {
            unset($this->StateCode);
        } else {
            $this->StateCode = $stateCode;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $countryCode
     * @return \SabreSoap\StructType\PassengerStatus
     */
    public function setCountryCode($countryCode = null)
    {
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return isset($this->CityCode) ? $this->CityCode : null;
    }
    /**
     * Set CityCode value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $cityCode
     * @return \SabreSoap\StructType\PassengerStatus
     */
    public function setCityCode($cityCode = null)
    {
        if (is_null($cityCode) || (is_array($cityCode) && empty($cityCode))) {
            unset($this->CityCode);
        } else {
            $this->CityCode = $cityCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\PassengerStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
