<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Partitions StructType
 * @subpackage Structs
 */
class Partitions extends AbstractStructBase
{
    /**
     * The Partition
     * Meta information extracted from the WSDL
     * - choice: Partition | Group
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * @var \SabreSoap\StructType\CachePartitionType
     */
    public $Partition;
    /**
     * The Group
     * Meta information extracted from the WSDL
     * - choice: Partition | Group
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * @var \SabreSoap\StructType\CachePartitionGroupType
     */
    public $Group;
    /**
     * Constructor method for Partitions
     * @uses Partitions::setPartition()
     * @uses Partitions::setGroup()
     * @param \SabreSoap\StructType\CachePartitionType $partition
     * @param \SabreSoap\StructType\CachePartitionGroupType $group
     */
    public function __construct(\SabreSoap\StructType\CachePartitionType $partition = null, \SabreSoap\StructType\CachePartitionGroupType $group = null)
    {
        $this
            ->setPartition($partition)
            ->setGroup($group);
    }
    /**
     * Get Partition value
     * @return \SabreSoap\StructType\CachePartitionType|null
     */
    public function getPartition()
    {
        return isset($this->Partition) ? $this->Partition : null;
    }
    /**
     * Set Partition value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\CachePartitionType $partition
     * @return \SabreSoap\StructType\Partitions
     */
    public function setPartition(\SabreSoap\StructType\CachePartitionType $partition = null)
    {
        if (is_null($partition) || (is_array($partition) && empty($partition))) {
            unset($this->Partition);
        } else {
            $this->Partition = $partition;
        }
        return $this;
    }
    /**
     * Get Group value
     * @return \SabreSoap\StructType\CachePartitionGroupType|null
     */
    public function getGroup()
    {
        return isset($this->Group) ? $this->Group : null;
    }
    /**
     * Set Group value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \SabreSoap\StructType\CachePartitionGroupType $group
     * @return \SabreSoap\StructType\Partitions
     */
    public function setGroup(\SabreSoap\StructType\CachePartitionGroupType $group = null)
    {
        if (is_null($group) || (is_array($group) && empty($group))) {
            unset($this->Group);
        } else {
            $this->Group = $group;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\Partitions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
