<?php

namespace SabreSoap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationOptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for flight segments.
 * @subpackage Structs
 */
class OriginDestinationOptionType extends AbstractStructBase
{
    /**
     * The FlightSegment
     * Meta information extracted from the WSDL
     * - documentation: A container for necessary data to describe one or more legs of a single flight number.
     * - maxOccurs: 4
     * @var \SabreSoap\StructType\BookFlightSegmentType[]
     */
    public $FlightSegment;
    /**
     * The ElapsedTime
     * Meta information extracted from the WSDL
     * - documentation: Elapsed leg trip time in minutes
     * - use: optional
     * @var int
     */
    public $ElapsedTime;
    /**
     * Constructor method for OriginDestinationOptionType
     * @uses OriginDestinationOptionType::setFlightSegment()
     * @uses OriginDestinationOptionType::setElapsedTime()
     * @param \SabreSoap\StructType\BookFlightSegmentType[] $flightSegment
     * @param int $elapsedTime
     */
    public function __construct(array $flightSegment = array(), $elapsedTime = null)
    {
        $this
            ->setFlightSegment($flightSegment)
            ->setElapsedTime($elapsedTime);
    }
    /**
     * Get FlightSegment value
     * @return \SabreSoap\StructType\BookFlightSegmentType[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @param \SabreSoap\StructType\BookFlightSegmentType[] $flightSegment
     * @return \SabreSoap\StructType\OriginDestinationOptionType
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \SabreSoap\StructType\BookFlightSegmentType $item
     * @return \SabreSoap\StructType\OriginDestinationOptionType
     */
    public function addToFlightSegment(\SabreSoap\StructType\BookFlightSegmentType $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return int|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param int $elapsedTime
     * @return \SabreSoap\StructType\OriginDestinationOptionType
     */
    public function setElapsedTime($elapsedTime = null)
    {
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SabreSoap\StructType\OriginDestinationOptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
